/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.xebialabs.overthere.CmdLineArgument;
import com.xebialabs.overthere.OperatingSystemFamily;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class CmdLine
implements Serializable {
    List<CmdLineArgument> arguments = Lists.newArrayList();

    public CmdLine addArgument(String string) {
        this.arguments.add(CmdLineArgument.arg(string));
        return this;
    }

    public CmdLine addPassword(String string) {
        this.arguments.add(CmdLineArgument.password(string));
        return this;
    }

    public CmdLine addRaw(String string) {
        this.arguments.add(CmdLineArgument.raw(string));
        return this;
    }

    public CmdLine addNested(CmdLine cmdLine) {
        this.arguments.add(CmdLineArgument.nested(cmdLine));
        return this;
    }

    public CmdLine add(CmdLineArgument cmdLineArgument) {
        Preconditions.checkNotNull((Object)cmdLineArgument, (Object)"Cannot add null CmdLineArgument");
        this.arguments.add(cmdLineArgument);
        return this;
    }

    public CmdLine add(List<CmdLineArgument> list) {
        Preconditions.checkNotNull(list, (Object)"Cannot add null List<CmdLineArgument>");
        this.arguments.addAll(list);
        return this;
    }

    public List<CmdLineArgument> getArguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    public String[] toCommandArray(final OperatingSystemFamily operatingSystemFamily, final boolean bl) {
        Preconditions.checkState((this.arguments.size() > 0 ? 1 : 0) != 0, (Object)"Cannot encode empty command line");
        return Lists.transform(this.arguments, (Function)new Function<CmdLineArgument, String>(){

            public String apply(CmdLineArgument cmdLineArgument) {
                return cmdLineArgument.toString(operatingSystemFamily, bl);
            }
        }).toArray(new String[this.arguments.size()]);
    }

    public String toCommandLine(OperatingSystemFamily operatingSystemFamily, boolean bl) {
        Preconditions.checkState((this.arguments.size() > 0 ? 1 : 0) != 0, (Object)"Cannot encode empty command line");
        StringBuilder stringBuilder = new StringBuilder();
        for (CmdLineArgument cmdLineArgument : this.arguments) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            cmdLineArgument.buildString(operatingSystemFamily, bl, stringBuilder);
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.toCommandLine(OperatingSystemFamily.UNIX, true);
    }

    public static CmdLine build(String ... stringArray) {
        CmdLine cmdLine = new CmdLine();
        for (String string : stringArray) {
            cmdLine.addArgument(string);
        }
        return cmdLine;
    }
}

