/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.cifs;

import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.cifs.PathMapper;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class PathEncoder {
    private static final Pattern UNC_PATH_PATTERN = Pattern.compile("\\\\\\\\[^\\\\]+\\\\([^\\\\]+(?:\\\\.*)?)");
    private static final char WINDOWS_SEPARATOR = '\\';
    private static final char SMB_URL_SEPARATOR = '/';
    private final String smbUrlPrefix;
    private final PathMapper pathMapper;

    PathEncoder(String string, String string2, String string3, int n, Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("smb://");
        if (string != null) {
            stringBuilder.append(PathEncoder.urlEncode(string.replaceFirst(Pattern.quote("\\"), ";")));
            stringBuilder.append(":");
            stringBuilder.append(PathEncoder.urlEncode(string2));
            stringBuilder.append("@");
        }
        stringBuilder.append(PathEncoder.urlEncode(string3));
        if (n != 445) {
            stringBuilder.append(":");
            stringBuilder.append(n);
        }
        stringBuilder.append('/');
        this.smbUrlPrefix = stringBuilder.toString();
        this.pathMapper = new PathMapper(map);
    }

    private static String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeIOException("Unable to construct SMB URL", unsupportedEncodingException);
        }
    }

    String toSmbUrl(String string) {
        if (string.length() < 2) {
            throw new IllegalArgumentException(String.format("Host path '%s' is too short", string));
        }
        if (string.charAt(1) != ':') {
            throw new IllegalArgumentException(String.format("Host path '%s' does not have a colon (:) as its second character", string));
        }
        if ((string = string.replace('/', '\\')).length() >= 3 && string.charAt(2) != '\\') {
            throw new IllegalArgumentException(String.format("Host path '%s' does not have a backslash (\\) as its third character", string));
        }
        StringBuilder stringBuilder = new StringBuilder(this.smbUrlPrefix);
        stringBuilder.append(this.pathMapper.toSharedPath(string).replace('\\', '/'));
        return stringBuilder.toString();
    }

    final String fromUncPath(String string) {
        Matcher matcher = UNC_PATH_PATTERN.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("UNC path '%s' did not match expected expression '%s'", string, UNC_PATH_PATTERN));
        }
        return this.pathMapper.toLocalPath(matcher.group(1));
    }
}

