/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.cifs.winrm;

import com.xebialabs.overthere.OverthereProcessOutputHandler;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.cifs.winrm.Action;
import com.xebialabs.overthere.cifs.winrm.HttpConnector;
import com.xebialabs.overthere.cifs.winrm.Namespaces;
import com.xebialabs.overthere.cifs.winrm.OptionSet;
import com.xebialabs.overthere.cifs.winrm.ResourceURI;
import com.xebialabs.overthere.cifs.winrm.ResponseExtractor;
import com.xebialabs.overthere.cifs.winrm.SoapAction;
import com.xebialabs.overthere.cifs.winrm.exception.WinRMRuntimeIOException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.List;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WinRmClient {
    private final URL targetURL;
    private final HttpConnector connector;
    private String timeout;
    private int envelopSize;
    private String locale;
    private String exitCode;
    private String shellId;
    private String commandId;
    private int chunk = 0;
    private static Logger logger = LoggerFactory.getLogger(WinRmClient.class);

    public WinRmClient(HttpConnector httpConnector, URL uRL) {
        this.connector = httpConnector;
        this.targetURL = uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runCmd(String string, OverthereProcessOutputHandler overthereProcessOutputHandler) {
        try {
            this.shellId = this.openShell();
            this.commandId = this.runCommand(string);
            this.getCommandOutput(overthereProcessOutputHandler);
        }
        finally {
            this.cleanUp();
            this.closeShell();
        }
    }

    private void closeShell() {
        if (this.shellId == null) {
            return;
        }
        logger.debug("closeShell shellId {}", (Object)this.shellId);
        Document document = this.getRequestDocument(Action.WS_DELETE, ResourceURI.RESOURCE_URI_CMD, null, this.shellId, null);
        this.sendMessage(document, null);
    }

    private void cleanUp() {
        if (this.commandId == null) {
            return;
        }
        logger.debug("cleanUp shellId {} commandId {} ", (Object)this.shellId, (Object)this.commandId);
        Element element = DocumentHelper.createElement((QName)QName.get((String)"Signal", (Namespace)Namespaces.NS_WIN_SHELL)).addAttribute("CommandId", this.commandId);
        element.addElement(QName.get((String)"Code", (Namespace)Namespaces.NS_WIN_SHELL)).addText("http://schemas.microsoft.com/wbem/wsman/1/windows/shell/signal/terminate");
        Document document = this.getRequestDocument(Action.WS_SIGNAL, ResourceURI.RESOURCE_URI_CMD, null, this.shellId, element);
        this.sendMessage(document, SoapAction.SIGNAL);
    }

    private void getCommandOutput(OverthereProcessOutputHandler overthereProcessOutputHandler) {
        Document document;
        Object object;
        logger.debug("getCommandOutput shellId {} commandId {} ", (Object)this.shellId, (Object)this.commandId);
        Element element = DocumentHelper.createElement((QName)QName.get((String)"Receive", (Namespace)Namespaces.NS_WIN_SHELL));
        element.addElement(QName.get((String)"DesiredStream", (Namespace)Namespaces.NS_WIN_SHELL)).addAttribute("CommandId", this.commandId).addText("stdout stderr");
        Document document2 = this.getRequestDocument(Action.WS_RECEIVE, ResourceURI.RESOURCE_URI_CMD, null, this.shellId, element);
        do {
            String string;
            document = this.sendMessage(document2, SoapAction.RECEIVE);
            String string2 = this.handleStream(document, ResponseExtractor.STDOUT);
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string2));
            try {
                while ((string = bufferedReader.readLine()) != null) {
                    overthereProcessOutputHandler.handleOutputLine(string);
                }
            }
            catch (IOException iOException) {
                throw new RuntimeIOException("Unexpected I/O exception while reading stdout", iOException);
            }
            string = this.handleStream(document, ResponseExtractor.STDERR);
            BufferedReader bufferedReader2 = new BufferedReader(new StringReader(string));
            try {
                while ((object = bufferedReader2.readLine()) != null) {
                    overthereProcessOutputHandler.handleErrorLine((String)object);
                }
            }
            catch (IOException iOException) {
                throw new RuntimeIOException("Unexpected I/O exception while reading stderr", iOException);
            }
            if (this.chunk == 0) {
                try {
                    this.exitCode = this.getFirstElement(document, ResponseExtractor.EXIT_CODE);
                    logger.info("exit code {}", (Object)this.exitCode);
                }
                catch (Exception exception) {
                    logger.debug("not found");
                }
            }
            ++this.chunk;
        } while ((object = ResponseExtractor.STREAM_DONE.getXPath().selectNodes((Object)document)).isEmpty());
        this.exitCode = this.getFirstElement(document, ResponseExtractor.EXIT_CODE);
        logger.info("exit code {}", (Object)this.exitCode);
        logger.debug("all the command output has been fetched (chunk={})", (Object)this.chunk);
    }

    private String handleStream(Document document, ResponseExtractor responseExtractor) {
        StringBuffer stringBuffer = new StringBuffer();
        List list = responseExtractor.getXPath().selectNodes((Object)document);
        if (!list.isEmpty()) {
            Base64 base64 = new Base64();
            for (Element element : list) {
                byte[] byArray = base64.decode(element.getText());
                stringBuffer.append(new String(byArray));
            }
        }
        logger.debug("handleStream {} buffer {}", (Object)responseExtractor, (Object)stringBuffer);
        return stringBuffer.toString();
    }

    private String runCommand(String string) {
        logger.debug("runCommand shellId {} command {}", (Object)this.shellId, (Object)string);
        Element element = DocumentHelper.createElement((QName)QName.get((String)"CommandLine", (Namespace)Namespaces.NS_WIN_SHELL));
        String string2 = string;
        string2 = "\"" + string2 + "\"";
        logger.info("Encoded command is {}", (Object)string2);
        element.addElement(QName.get((String)"Command", (Namespace)Namespaces.NS_WIN_SHELL)).addText(string2);
        Document document = this.getRequestDocument(Action.WS_COMMAND, ResourceURI.RESOURCE_URI_CMD, OptionSet.RUN_COMMAND, this.shellId, element);
        Document document2 = this.sendMessage(document, SoapAction.COMMAND_LINE);
        return this.getFirstElement(document2, ResponseExtractor.COMMAND_ID);
    }

    private String getFirstElement(Document document, ResponseExtractor responseExtractor) {
        List list = responseExtractor.getXPath().selectNodes((Object)document);
        if (list.isEmpty()) {
            throw new RuntimeException("Cannot find " + responseExtractor.getXPath() + " in " + this.toString(document));
        }
        Element element = (Element)list.iterator().next();
        return element.getText();
    }

    private String openShell() {
        logger.debug("openShell");
        Element element = DocumentHelper.createElement((QName)QName.get((String)"Shell", (Namespace)Namespaces.NS_WIN_SHELL));
        element.addElement(QName.get((String)"InputStreams", (Namespace)Namespaces.NS_WIN_SHELL)).addText("stdin");
        element.addElement(QName.get((String)"OutputStreams", (Namespace)Namespaces.NS_WIN_SHELL)).addText("stdout stderr");
        Document document = this.getRequestDocument(Action.WS_ACTION, ResourceURI.RESOURCE_URI_CMD, OptionSet.OPEN_SHELL, null, element);
        Document document2 = this.sendMessage(document, SoapAction.SHELL);
        return this.getFirstElement(document2, ResponseExtractor.SHELL_ID);
    }

    private Document sendMessage(Document document, SoapAction soapAction) {
        return this.connector.sendMessage(document, soapAction);
    }

    private Document getRequestDocument(Action action, ResourceURI resourceURI, OptionSet optionSet, String string, Element element) {
        Document document = DocumentHelper.createDocument();
        Element element2 = document.addElement(QName.get((String)"Envelope", (Namespace)Namespaces.NS_SOAP_ENV));
        element2.add(this.getHeader(action, resourceURI, optionSet, string));
        Element element3 = element2.addElement(QName.get((String)"Body", (Namespace)Namespaces.NS_SOAP_ENV));
        if (element != null) {
            element3.add(element);
        }
        return document;
    }

    private Element getHeader(Action action, ResourceURI resourceURI, OptionSet optionSet, String string) {
        Element element = DocumentHelper.createElement((QName)QName.get((String)"Header", (Namespace)Namespaces.NS_SOAP_ENV));
        element.addElement(QName.get((String)"To", (Namespace)Namespaces.NS_ADDRESSING)).addText(this.targetURL.toString());
        Element element2 = element.addElement(QName.get((String)"ReplyTo", (Namespace)Namespaces.NS_ADDRESSING));
        element2.addElement(QName.get((String)"Address", (Namespace)Namespaces.NS_ADDRESSING)).addAttribute("mustUnderstand", "true").addText("http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous");
        element.addElement(QName.get((String)"MaxEnvelopeSize", (Namespace)Namespaces.NS_WSMAN_DMTF)).addAttribute("mustUnderstand", "true").addText("" + this.envelopSize);
        element.addElement(QName.get((String)"MessageID", (Namespace)Namespaces.NS_ADDRESSING)).addText(this.getUUID());
        element.addElement(QName.get((String)"Locale", (Namespace)Namespaces.NS_WSMAN_DMTF)).addAttribute("mustUnderstand", "false").addAttribute("xml:lang", this.locale);
        element.addElement(QName.get((String)"DataLocale", (Namespace)Namespaces.NS_WSMAN_MSFT)).addAttribute("mustUnderstand", "false").addAttribute("xml:lang", this.locale);
        element.addElement(QName.get((String)"OperationTimeout", (Namespace)Namespaces.NS_WSMAN_DMTF)).addText(this.timeout);
        element.add(action.getElement());
        if (string != null) {
            element.addElement(QName.get((String)"SelectorSet", (Namespace)Namespaces.NS_WSMAN_DMTF)).addElement(QName.get((String)"Selector", (Namespace)Namespaces.NS_WSMAN_DMTF)).addAttribute("Name", "ShellId").addText(string);
        }
        element.add(resourceURI.getElement());
        if (optionSet != null) {
            element.add(optionSet.getElement());
        }
        return element;
    }

    private String toString(Document document) {
        StringWriter stringWriter = new StringWriter();
        XMLWriter xMLWriter = new XMLWriter((Writer)stringWriter, OutputFormat.createPrettyPrint());
        try {
            xMLWriter.write(document);
            xMLWriter.close();
        }
        catch (IOException iOException) {
            throw new WinRMRuntimeIOException("error ", iOException);
        }
        return stringWriter.toString();
    }

    private String getUUID() {
        return "uuid:" + UUID.randomUUID().toString().toUpperCase();
    }

    public int getExitCode() {
        return Integer.parseInt(this.exitCode);
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String string) {
        this.timeout = string;
    }

    public int getEnvelopSize() {
        return this.envelopSize;
    }

    public void setEnvelopSize(int n) {
        this.envelopSize = n;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String string) {
        this.locale = string;
    }

    public URL getTargetURL() {
        return this.targetURL;
    }
}

