/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.local;

import com.google.common.collect.Lists;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.local.LocalConnection;
import com.xebialabs.overthere.spi.BaseOverthereFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class LocalFile
extends BaseOverthereFile<LocalConnection>
implements Serializable {
    protected File file;

    public LocalFile(LocalConnection localConnection, File file) {
        super(localConnection);
        this.file = file;
    }

    @Override
    public final LocalConnection getConnection() {
        if (this.connection == null) {
            this.connection = LocalFile.createConnection();
        }
        return (LocalConnection)this.connection;
    }

    private static LocalConnection createConnection() {
        LocalConnection localConnection = new LocalConnection("local", new ConnectionOptions());
        return localConnection;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public String getPath() {
        return this.file.getPath();
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public OverthereFile getParentFile() {
        return this.getConnection().getFile(this.file.getParent());
    }

    @Override
    public long lastModified() {
        return this.file.lastModified();
    }

    @Override
    public long length() {
        return this.file.length();
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public boolean isFile() {
        return this.file.isFile();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public boolean isHidden() {
        return this.file.isHidden();
    }

    @Override
    public boolean canRead() {
        return this.file.canRead();
    }

    @Override
    public boolean canWrite() {
        return this.file.canWrite();
    }

    @Override
    public boolean canExecute() {
        return this.file.canExecute();
    }

    @Override
    public void setExecutable(boolean bl) {
        this.file.setExecutable(bl);
    }

    @Override
    public void delete() {
        if (!this.file.delete()) {
            throw new RuntimeIOException("Cannot delete " + this);
        }
    }

    @Override
    public void mkdir() {
        if (!this.file.mkdir()) {
            throw new RuntimeIOException("Cannot mkdir " + this);
        }
    }

    @Override
    public void mkdirs() {
        if (!this.file.mkdirs()) {
            throw new RuntimeIOException("Cannot mkdir " + this);
        }
    }

    @Override
    public List<OverthereFile> listFiles() {
        ArrayList arrayList = Lists.newArrayList();
        for (File file : this.file.listFiles()) {
            arrayList.add(new LocalFile((LocalConnection)this.connection, file));
        }
        return arrayList;
    }

    @Override
    public void renameTo(OverthereFile overthereFile) {
        if (!(overthereFile instanceof LocalFile)) {
            throw new RuntimeIOException("Destination is not a " + LocalFile.class.getName());
        }
        if (!this.file.renameTo(((LocalFile)overthereFile).file)) {
            throw new RuntimeIOException("Cannot rename " + this + " to " + overthereFile);
        }
    }

    @Override
    public InputStream getInputStream() {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeIOException("Cannot open " + this + " for reading", fileNotFoundException);
        }
    }

    @Override
    public OutputStream getOutputStream() {
        try {
            return new FileOutputStream(this.file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeIOException("Cannot open " + this + " for writing", fileNotFoundException);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof LocalFile)) {
            return false;
        }
        return this.file.equals(((LocalFile)object).file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    @Override
    public String toString() {
        return "local:" + this.file;
    }

    public static OverthereFile valueOf(File file) {
        return new LocalFile(LocalFile.createConnection(), file);
    }
}

