/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.google.common.base.Preconditions;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.CmdLineArgument;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.ssh.SshProcess;
import com.xebialabs.overthere.ssh.SshSftpConnection;
import java.util.List;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.transport.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SshSftpCygwinConnection
extends SshSftpConnection {
    private Logger logger = LoggerFactory.getLogger(SshSftpCygwinConnection.class);

    public SshSftpCygwinConnection(String string, ConnectionOptions connectionOptions, AddressPortMapper addressPortMapper) {
        super(string, connectionOptions, addressPortMapper);
        Preconditions.checkArgument((this.os == OperatingSystemFamily.WINDOWS ? 1 : 0) != 0, (String)"Cannot start a ssh:%s connection to a non-Windows operating system", (Object[])new Object[]{this.sshConnectionType.toString().toLowerCase()});
    }

    @Override
    protected String pathToSftpPath(String string) {
        String string2 = this.toCygwinPath(string);
        if (string2 == null) {
            throw new RuntimeIOException("Cannot translate path " + string + " to SFTP path because it is not a Windows path or a Cygwin path");
        }
        return string2;
    }

    protected String toCygwinPath(String string) {
        if (string.length() >= 2 && string.charAt(1) == ':') {
            char c = Character.toLowerCase(string.charAt(0));
            String string2 = string.substring(2).replace('\\', '/');
            String string3 = "/cygdrive/" + c + string2;
            this.logger.trace("Translated Windows path [{}] to Cygdrive path [{}]", (Object)string, (Object)string3);
            return string3;
        }
        if (string.startsWith("/cygdrive/")) {
            return string;
        }
        return null;
    }

    @Override
    protected CmdLine processCommandLine(CmdLine cmdLine) {
        List<CmdLineArgument> list = cmdLine.getArguments();
        Preconditions.checkArgument((list.size() > 0 ? 1 : 0) != 0, (Object)"Empty command line");
        String string = list.get(0).toString();
        String string2 = this.toCygwinPath(string);
        if (string2 != null) {
            CmdLine cmdLine2 = new CmdLine();
            cmdLine2.add(CmdLineArgument.arg(string2));
            for (int i = 1; i < list.size(); ++i) {
                cmdLine2.add(list.get(i));
            }
            this.logger.debug("Translated first element (command) of command line from Windows path [{}] to Cygwin path [{}]", (Object)string, (Object)string2);
            return super.processCommandLine(cmdLine2);
        }
        return super.processCommandLine(cmdLine);
    }

    @Override
    protected SshProcess createProcess(Session session, CmdLine cmdLine) throws TransportException, ConnectionException {
        return new SshProcess(this, OperatingSystemFamily.UNIX, session, cmdLine);
    }
}

