/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.io;

import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.InputSupplier;
import com.xebialabs.deployit.util.GuavaFiles;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class Exploder {
    private static final Logger logger = LoggerFactory.getLogger(Exploder.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void explode(InputSupplier<? extends InputStream> inputSupplier, File file) throws IOException {
        ZipInputStream zipInputStream = null;
        try {
            ZipEntry zipEntry;
            zipInputStream = new ZipInputStream((InputStream)inputSupplier.getInput());
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                try {
                    Object object;
                    File file2;
                    if (zipEntry.isDirectory()) {
                        file2 = new File(file, zipEntry.getName());
                        if (file2.exists()) continue;
                        Assert.isTrue((boolean)file2.mkdirs(), (String)("Could not create directory: " + zipEntry.getName()));
                        continue;
                    }
                    file2 = new File(file, zipEntry.getName());
                    String string = file2.getParent();
                    if (string != null && !((File)(object = new File(string))).exists()) {
                        Assert.isTrue((boolean)((File)object).mkdirs(), (String)("Could not create directory: " + zipEntry.getName()));
                    }
                    Assert.isTrue((boolean)file2.createNewFile(), (String)("Could not create file: " + zipEntry.getName()));
                    object = new FileOutputStream(file2);
                    try {
                        ByteStreams.copy((InputStream)zipInputStream, (OutputStream)object);
                    }
                    finally {
                        Closeables.closeQuietly((Closeable)object);
                    }
                }
                finally {
                    zipInputStream.closeEntry();
                }
            }
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(zipInputStream);
            throw throwable;
        }
        {
            catch (IOException iOException) {
                try {
                    GuavaFiles.deleteRecursively(file);
                    throw iOException;
                }
                catch (Exception exception) {
                    logger.error("Could not delete {}", (Object)file, (Object)exception);
                }
                throw iOException;
                break;
            }
        }
        Closeables.closeQuietly((Closeable)zipInputStream);
    }
}

