/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.security.JcrUser;
import com.xebialabs.deployit.security.UserService;
import java.io.IOException;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JcrUserService
implements UserService {
    @Autowired
    private JcrTemplate jcrTemplate;

    @Override
    public void create(final String string, final String string2) {
        this.jcrTemplate.execute(new JcrCallback<Object>(){

            @Override
            public Object doInJcr(Session session) throws IOException, RepositoryException {
                UserManager userManager = ((JackrabbitSession)session).getUserManager();
                userManager.createUser(string, string2);
                return null;
            }
        });
    }

    @Override
    public JcrUser read(final String string) {
        return this.jcrTemplate.execute(new JcrCallback<JcrUser>(){

            @Override
            public JcrUser doInJcr(Session session) throws IOException, RepositoryException {
                User user = JcrUserService.this.getUser(string, session);
                return new JcrUser(user.getID(), user.isAdmin());
            }
        });
    }

    @Override
    public void modifyPassword(final String string, final String string2) {
        this.jcrTemplate.execute(new JcrCallback<Object>(){

            @Override
            public Object doInJcr(Session session) throws IOException, RepositoryException {
                User user = JcrUserService.this.getUser(string, session);
                user.changePassword(string2);
                return null;
            }
        });
    }

    @Override
    public void delete(final String string) {
        this.jcrTemplate.execute(new JcrCallback<Object>(){

            @Override
            public Object doInJcr(Session session) throws IOException, RepositoryException {
                User user = JcrUserService.this.getUser(string, session);
                user.remove();
                return null;
            }
        });
    }

    private User getUser(String string, Session session) throws AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
        UserManager userManager = ((JackrabbitSession)session).getUserManager();
        Authorizable authorizable = userManager.getAuthorizable(string);
        if (authorizable == null) {
            throw new NotFoundException("No such user: " + string, new Object[0]);
        }
        if (authorizable.isGroup()) {
            throw new IllegalStateException("Principal " + string + " is not a user");
        }
        User user = (User)authorizable;
        return user;
    }
}

