/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.core.Directory;
import com.xebialabs.deployit.repository.internal.Root;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PermissionEditor {
    private final JcrTemplate jcrTemplate;
    private final RoleService roleService;
    private static final Logger logger = LoggerFactory.getLogger(PermissionEditor.class);

    @Autowired
    public PermissionEditor(JcrTemplate jcrTemplate, RoleService roleService) {
        this.jcrTemplate = jcrTemplate;
        this.roleService = roleService;
    }

    public Multimap<Role, Permission> readPermissions(String string) {
        final String string2 = this.getPath(string);
        logger.debug("Reading permissions from [{}]", (Object)string2);
        return this.jcrTemplate.execute(new JcrCallback<Multimap<Role, Permission>>(){

            @Override
            public Multimap<Role, Permission> doInJcr(Session session) throws IOException, RepositoryException {
                return PermissionEditor.this.internalReadPermissions(session, string2);
            }
        });
    }

    public void editPermissions(String string, final Multimap<Role, Permission> multimap) {
        final String string2 = this.getPath(string);
        logger.debug("Going to write permissions {} to node [{}]", multimap, (Object)string2);
        Collection<Permission> collection = Permissions.isApplicableTo(multimap.values(), string);
        Checks.checkArgument(collection.isEmpty(), "The permissions %s are not applicable to [%s]", collection, string);
        this.jcrTemplate.execute(new JcrCallback<Object>(){

            @Override
            public Object doInJcr(Session session) throws IOException, RepositoryException {
                PermissionEditor.this.internalWritePermissions(session, string2, (Multimap<Role, Permission>)multimap);
                session.save();
                return null;
            }
        });
    }

    private Multimap<Role, Permission> internalReadPermissions(Session session, String string) throws RepositoryException {
        Checks.checkArgument(session.nodeExists(string), "Couldn't find a node at [%s]", JcrPathHelper.getIdFromAbsolutePath(string));
        Node node = session.getNode(string);
        this.checkType(node);
        HashMultimap hashMultimap = HashMultimap.create();
        ImmutableMap<Integer, Role> immutableMap = Permissions.buildLookup(this.roleService.readRoles());
        Map<String, String> map = Permissions.readPermissionMap(node);
        logger.debug("Found permission entries on node: {}", map);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Permission permission = Permission.find(entry.getKey());
            for (Integer n : Permissions.splitRoles(entry.getValue())) {
                if (!immutableMap.containsKey((Object)n)) continue;
                hashMultimap.put(immutableMap.get((Object)n), (Object)permission);
            }
        }
        logger.debug("Read from [{}] permissions {}", (Object)string, (Object)hashMultimap);
        return hashMultimap;
    }

    private void checkType(Node node) throws RepositoryException {
        if (node.hasProperty("$configuration.item.type")) {
            Type type = Type.valueOf((String)node.getProperty("$configuration.item.type").getString());
            Checks.checkArgument(type.equals((Object)Type.valueOf(Root.class)) || type.equals((Object)Type.valueOf(Directory.class)), "Only 'core.Directory' and 'internal.Root' nodes can contain security permissions, not [{}]", type);
        }
    }

    private void internalWritePermissions(Session session, String string, Multimap<Role, Permission> multimap) throws RepositoryException {
        Node node = session.getNode(string);
        HashMultimap hashMultimap = HashMultimap.create();
        Multimaps.invertFrom(multimap, (Multimap)hashMultimap);
        HashMap hashMap = Maps.newHashMap();
        for (Permission permission : hashMultimap.keySet()) {
            Collection collection = hashMultimap.get((Object)permission);
            String string2 = Permissions.joinRoles(Permissions.rolesToIds(collection));
            logger.debug("Going to write permission-roles: [{} -> {}]", (Object)permission, (Object)string2);
            hashMap.put(permission.getPermissionName(), string2);
        }
        Permissions.writePermissionMap(node, hashMap);
    }

    private String getPath(String string) {
        String string2 = Strings.nullToEmpty((String)string).isEmpty() ? "/$configuration/security" : JcrPathHelper.getAbsolutePathFromId(string);
        return string2;
    }
}

