/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.service.deployment.DeployedGenerator;
import com.xebialabs.deployit.service.deployment.TypeCalculator;
import com.xebialabs.deployit.service.replacement.ConsolidatedDictionary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeployedService {
    private DeployedGenerator deployedGenerator;
    private TypeCalculator typeCalculator;
    private static final Logger logger = LoggerFactory.getLogger(DeployedService.class);

    @Autowired
    public DeployedService(DeployedGenerator deployedGenerator, TypeCalculator typeCalculator) {
        this.deployedGenerator = deployedGenerator;
        this.typeCalculator = typeCalculator;
    }

    public ListMultimap<Boolean, ConfigurationItem> generateAllDeployeds(Version version, Environment environment) {
        Set set = environment.getMembers();
        ConsolidatedDictionary consolidatedDictionary = ConsolidatedDictionary.create(environment.getDictionaries());
        List<Deployed> list = this.generateDeployedsOfType(version.getDeployables(), set, null, consolidatedDictionary);
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Could not generate any deployeds for " + version.getId() + " and " + environment.getId());
        }
        return this.createValidDeployedMap(list, Lists.newArrayList());
    }

    public ListMultimap<Boolean, ConfigurationItem> generateSelectedDeployeds(List<ConfigurationItem> list, Environment environment) {
        Set set = environment.getMembers();
        ConsolidatedDictionary consolidatedDictionary = ConsolidatedDictionary.create(environment.getDictionaries());
        List list2 = Lists.transform(list, (Function)new Function<ConfigurationItem, Deployable>(){

            public Deployable apply(ConfigurationItem configurationItem) {
                Checks.checkArgument(configurationItem instanceof Deployable, "The entity %s is not a deployable", configurationItem.getId());
                return (Deployable)configurationItem;
            }
        });
        return this.createValidDeployedMap(this.generateDeployedsOfType(list2, set, null, consolidatedDictionary), Lists.newArrayList());
    }

    public ListMultimap<Boolean, ConfigurationItem> createSelectedDeployed(Deployable deployable, Container container, String string, Environment environment) {
        logger.debug("Creating deployed for [{}] and [{}]", (Object)deployable, (Object)container);
        Type type = null;
        if (!Strings.nullToEmpty((String)string).trim().isEmpty()) {
            type = Type.valueOf((String)string);
            logger.debug("Using explicit type: {}", (Object)type);
        }
        ConsolidatedDictionary consolidatedDictionary = ConsolidatedDictionary.create(environment.getDictionaries());
        return this.createValidDeployedMap(this.generateDeployedsOfType(Lists.newArrayList((Object[])new Deployable[]{deployable}), Lists.newArrayList((Object[])new Container[]{container}), type, consolidatedDictionary, true), Lists.newArrayList());
    }

    public ListMultimap<Boolean, ConfigurationItem> generateUpgradedDeployeds(Version version, DeployedApplication deployedApplication) {
        Environment environment = deployedApplication.getEnvironment();
        ConsolidatedDictionary consolidatedDictionary = ConsolidatedDictionary.create(environment.getDictionaries());
        ArrayList arrayList = Lists.newArrayList();
        ArrayList arrayList2 = Lists.newArrayList();
        for (final Deployed deployed : deployedApplication.getDeployeds()) {
            Collection collection = Collections2.filter((Collection)version.getDeployables(), (Predicate)new Predicate<Deployable>(){

                public boolean apply(Deployable deployable) {
                    return DeployedService.this.isSimilar(deployable, deployed.getDeployable());
                }
            });
            if (collection.size() == 0) {
                arrayList2.add(this.deployedGenerator.generateUpgradedDeployed(deployed.getDeployable(), deployed, consolidatedDictionary));
                continue;
            }
            if (collection.size() == 1) {
                arrayList.add(this.deployedGenerator.generateUpgradedDeployed((Deployable)collection.iterator().next(), deployed, consolidatedDictionary));
                continue;
            }
            throw new IllegalArgumentException(String.format("More than 1 applicable deployable found in new package for %s, will not fly.", deployed));
        }
        return this.createValidDeployedMap(arrayList, arrayList2);
    }

    private ListMultimap<Boolean, ConfigurationItem> createValidDeployedMap(List<Deployed> list, List<Deployed> list2) {
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        arrayListMultimap.putAll((Object)Boolean.TRUE, list);
        arrayListMultimap.putAll((Object)Boolean.FALSE, list2);
        return arrayListMultimap;
    }

    private boolean isSimilar(Deployable deployable, Deployable deployable2) {
        return deployable.getType().equals((Object)deployable2.getType()) && deployable.getName().equals(deployable2.getName());
    }

    private List<Deployed> generateDeployedsOfType(Collection<Deployable> collection, Collection<Container> collection2, Type type, ConsolidatedDictionary consolidatedDictionary) {
        return this.generateDeployedsOfType(collection, collection2, type, consolidatedDictionary, false);
    }

    private List<Deployed> generateDeployedsOfType(Collection<Deployable> collection, Collection<Container> collection2, Type type, ConsolidatedDictionary consolidatedDictionary, boolean bl) {
        ArrayList arrayList = Lists.newArrayList();
        for (Deployable deployable : collection) {
            for (Container container : collection2) {
                if (type != null) {
                    if (!this.typeCalculator.findDeployedTypesForDeployableAndContainerTypes(deployable.getType(), container.getType()).contains(type)) continue;
                    arrayList.add(this.deployedGenerator.generateDeployed(deployable, container, type, consolidatedDictionary));
                    continue;
                }
                Deployed<?, ?> deployed = null;
                if (bl) {
                    logger.debug("Creating manual deployed for [{}] and [{}]", (Object)deployable, (Object)container);
                    deployed = this.deployedGenerator.createMostSpecificDeployed(deployable, container, consolidatedDictionary);
                } else {
                    logger.debug("Creating automatic deployed for [{}] and [{}]", (Object)deployable, (Object)container);
                    deployed = this.deployedGenerator.generateMostSpecificDeployed(deployable, container, consolidatedDictionary);
                }
                if (deployed == null) continue;
                arrayList.add(deployed);
            }
        }
        return arrayList;
    }
}

