/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.task.StepList;
import com.xebialabs.deployit.task.Task;
import com.xebialabs.deployit.task.TaskStep;
import java.util.ArrayList;
import java.util.List;

public abstract class DeploymentTask
extends Task {
    private ArrayList<WorkDir> workDirs = Lists.newArrayList();
    protected final transient RepositoryService repositoryService;
    private String applicationName;
    private String applicationVersion;
    private String environment;
    private String environmentId;

    public DeploymentTask(List<? extends DeploymentStep> list, RepositoryService repositoryService, WorkDir ... workDirArray) {
        super(list);
        this.repositoryService = repositoryService;
        if (workDirArray != null) {
            this.workDirs = Lists.newArrayList((Object[])workDirArray);
        }
    }

    protected DeploymentTask(List<TaskStep> list, Task.State state) {
        this(new StepList(list, list.size()), state);
    }

    DeploymentTask(StepList stepList, Task.State state) {
        super(stepList, state);
        this.repositoryService = null;
    }

    @Override
    public void destroy() {
        for (WorkDir workDir : this.workDirs) {
            workDir.delete();
        }
        super.destroy();
    }

    protected void initFromDeployment(DeployedApplication deployedApplication) {
        this.setApplicationName(deployedApplication.getVersion().getApplication().getName());
        this.setApplicationVersion(deployedApplication.getVersion().getVersion());
        this.setEnvironment(deployedApplication.getEnvironment().getName());
        this.environmentId = deployedApplication.getEnvironment().getId();
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String string) {
        this.applicationName = string;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public void setApplicationVersion(String string) {
        this.applicationVersion = string;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String string) {
        this.environment = string;
    }

    public String getEnvironmentId() {
        return this.environmentId;
    }

    public abstract DeploymentType getDeploymentType();

    public static enum DeploymentType {
        INITIAL,
        UPGRADE,
        UNDEPLOY,
        UNKNOWN;

    }
}

