/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.task.DeploymentTask;
import com.xebialabs.deployit.task.Task;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class Registry {
    private ConcurrentMap<String, Task> reg = new ConcurrentHashMap<String, Task>();

    Registry() {
    }

    void register(Task task) {
        Preconditions.checkArgument((task.getId() != null ? 1 : 0) != 0, (Object)"task ID should have been set.");
        Preconditions.checkState((this.reg.putIfAbsent(task.getId(), task) == null ? 1 : 0) != 0);
    }

    public Task retrieve(String string) {
        return (Task)this.reg.get(string);
    }

    public void remove(String string) {
        this.reg.remove(string);
    }

    public Collection<Task> tasks() {
        return this.reg.values();
    }

    public void writeRecovery(ObjectOutputStream objectOutputStream) throws IOException {
        ArrayList arrayList = Lists.newArrayList((Iterable)Collections2.filter(this.reg.values(), (Predicate)new Predicate<Task>(){

            public boolean apply(Task task) {
                return task instanceof DeploymentTask;
            }
        }));
        objectOutputStream.writeObject(arrayList);
    }

    public void recover(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object = objectInputStream.readObject();
        if (object instanceof Collection) {
            for (Task task : (Collection)object) {
                this.reg.put(task.getId(), task);
            }
        }
    }

    public boolean hasInProgressTasks() {
        return !this.reg.isEmpty();
    }
}

