/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import com.xebialabs.deployit.ClosingExceptionMapper;
import com.xebialabs.deployit.DeployitExceptionMapper;
import com.xebialabs.deployit.Sanitizer;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.exception.DeployitException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Provider
@Component
public class UnhandledExceptionMapper
extends ClosingExceptionMapper<RuntimeException>
implements ExceptionMapper<RuntimeException> {
    private static final Logger logger = LoggerFactory.getLogger(UnhandledExceptionMapper.class);

    @Override
    protected Response handleException(RuntimeException runtimeException) {
        logger.debug("Intercepting (possibly) unhandled exception...");
        if (runtimeException instanceof DeployitException) {
            return new DeployitExceptionMapper().toResponse((DeployitException)runtimeException);
        }
        logger.error("Unhandled Exception: {}", (Throwable)runtimeException);
        Response.ResponseBuilder responseBuilder = ResponseFactory.serverError().type("application/xml");
        responseBuilder.header("Unhandled-Exception", (Object)"true");
        responseBuilder.header("Exception-Type", (Object)runtimeException.getClass().getName());
        responseBuilder.entity((Object)Sanitizer.sanitize(runtimeException.getMessage()));
        return responseBuilder.build();
    }
}

