/*
 * Decompiled with CFR 0.152.
 */
package nl.javadude.scannit.metadata;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.annotation.Annotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavassistHelper {
    public static ClassFile readFile(TFile file) {
        try {
            TFileInputStream tFileInputStream = new TFileInputStream((File)file);
            return JavassistHelper.readFromInputStream((InputStream)tFileInputStream);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Could not find file: " + file, e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read file: " + file, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassFile readFromInputStream(InputStream is) throws IOException {
        ClassFile classFile;
        if (is == null) {
            throw new IllegalArgumentException("Cannot read from a null inputstream");
        }
        DataInputStream in = null;
        try {
            in = new DataInputStream(new BufferedInputStream(is));
            classFile = new ClassFile(in);
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(in);
            throw throwable;
        }
        Closeables.closeQuietly((Closeable)in);
        return classFile;
    }

    public static List<String> getTypeAnnotations(ClassFile file) {
        AnnotationsAttribute attribute = (AnnotationsAttribute)file.getAttribute("RuntimeVisibleAnnotations");
        return JavassistHelper.readAnnotations(attribute);
    }

    private static List<String> readAnnotations(AnnotationsAttribute attribute) {
        if (attribute == null) {
            return Lists.newArrayList();
        }
        Object[] annotations = attribute.getAnnotations();
        return Lists.transform((List)Lists.newArrayList((Object[])annotations), (Function)new Function<Annotation, String>(){

            public String apply(Annotation input) {
                return input.getTypeName();
            }
        });
    }

    public static List<String> getMethodAnnotations(MethodInfo method) {
        AnnotationsAttribute attribute = (AnnotationsAttribute)method.getAttribute("RuntimeVisibleAnnotations");
        return JavassistHelper.readAnnotations(attribute);
    }

    public static List<String> getFieldAnnotations(FieldInfo field) {
        AnnotationsAttribute attribute = (AnnotationsAttribute)field.getAttribute("RuntimeVisibleAnnotations");
        return JavassistHelper.readAnnotations(attribute);
    }
}

