/*
 * Decompiled with CFR 0.152.
 */
package nl.javadude.scannit.reader;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathReader {
    private Function<URL, URI> url2uri = new Function<URL, URI>(){

        public URI apply(URL url) {
            try {
                logger.debug("Encountered URL: {}", (Object)url);
                return url.toURI();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Could not convert URL: " + url + " to a URI", e);
            }
        }
    };
    private static final Logger logger = LoggerFactory.getLogger(ClasspathReader.class);

    public Set<URI> findURIs(String packagePrefix) {
        List uris;
        String filePath = this.packagePrefixToPath(packagePrefix);
        logger.debug("Finding resources for prefix: {}", (Object)filePath);
        ClassLoader contextClassLoader = this.getClassLoader();
        try {
            Enumeration<URL> resources = contextClassLoader.getResources(filePath);
            uris = Lists.transform((List)Lists.newArrayList((Iterator)Iterators.forEnumeration(resources)), this.url2uri);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not fetch the resources matching " + filePath + " from the context classloader.", e);
        }
        return Sets.newHashSet((Iterable)uris);
    }

    private String packagePrefixToPath(String packagePrefix) {
        return packagePrefix.replaceAll("\\.", "/");
    }

    protected ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public Set<URI> findBaseURIs(String prefix) {
        HashSet result = Sets.newHashSet();
        Set<URI> urIs = this.findURIs(prefix);
        String path = this.packagePrefixToPath(prefix);
        for (URI urI : urIs) {
            String schemeSpecificPart = urI.getSchemeSpecificPart();
            String based = schemeSpecificPart.substring(0, schemeSpecificPart.length() - path.length());
            try {
                result.add(new URI(urI.getScheme(), based, urI.getFragment()));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        logger.debug("Found base uris: {}", (Object)result);
        return result;
    }
}

