/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.api.resteasy.http.tunnel;

import com.xebialabs.deployit.core.api.resteasy.http.tunnel.HeaderName;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.TunneledResponseBuilder;
import java.util.List;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.RuntimeDelegate;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseFactory {
    private static Logger logger = LoggerFactory.getLogger(ResponseFactory.class);

    public static Response.ResponseBuilder getInstance() {
        List list;
        HttpRequest httpRequest = (HttpRequest)ResteasyProviderFactory.getContextData(HttpRequest.class);
        if (httpRequest != null && (list = httpRequest.getHttpHeaders().getRequestHeader(HeaderName.WANT_TUNNEL_HEADER.getHeader())) != null && !list.isEmpty()) {
            logger.debug("Returning TunneledResponseBuilder for {}", (Object)httpRequest);
            return new TunneledResponseBuilder();
        }
        logger.debug("Returning regular ResponseBuilder for {}", (Object)httpRequest);
        return RuntimeDelegate.getInstance().createResponseBuilder();
    }

    public static Response.ResponseBuilder status(Response.Status status) {
        return ResponseFactory.getInstance().status(status);
    }

    public static Response.ResponseBuilder status(int n) {
        return ResponseFactory.getInstance().status(n);
    }

    public static Response.ResponseBuilder serverError() {
        return ResponseFactory.getInstance().status(Response.Status.INTERNAL_SERVER_ERROR);
    }

    public static Response.ResponseBuilder ok(Object object) {
        return ResponseFactory.getInstance().status(Response.Status.OK).entity(object);
    }

    public static Response.ResponseBuilder ok() {
        return ResponseFactory.getInstance().status(Response.Status.OK);
    }

    public static Response.ResponseBuilder noContent() {
        return ResponseFactory.getInstance().status(Response.Status.NO_CONTENT);
    }

    public static Response.ResponseBuilder notModified() {
        return ResponseFactory.getInstance().status(Response.Status.NOT_MODIFIED);
    }

    public static Response.ResponseBuilder created(Object object) {
        return ResponseFactory.getInstance().status(Response.Status.CREATED).entity(object);
    }

    public static Response.ResponseBuilder badRequest(Object object) {
        return ResponseFactory.getInstance().status(Response.Status.BAD_REQUEST).entity(object);
    }

    public static Response.ResponseBuilder accepted() {
        return ResponseFactory.getInstance().status(Response.Status.ACCEPTED);
    }
}

