/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.help;

import com.xebialabs.deployit.cli.Cli;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;

public class ExportHelp {
    private ExportHelp() {
    }

    public static final String parseDateFormat(String string, String string2, String string3) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2, Locale.ENGLISH);
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat(string3, Locale.ENGLISH);
            simpleDateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
            return simpleDateFormat2.format(simpleDateFormat.parse(string));
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(String.format("Cannot parse date; should be in format %s", string2));
        }
    }

    public static final String encodeURIDateFormat(String string, String string2) {
        try {
            return URLEncoder.encode(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(String.format("Cannot parse date because of unsupported encoding; should be in %s encoding", string2));
        }
    }

    public static final long writeResourceToLocalFile(Cli.Authentication authentication, String string, String string2) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            HttpClient httpClient = authentication.getHttpClient();
            GetMethod getMethod = new GetMethod(string2);
            int n = httpClient.executeMethod((HttpMethod)getMethod);
            if (n == 200) {
                long l = 0L;
                fileOutputStream = new FileOutputStream(string);
                FileChannel fileChannel = fileOutputStream.getChannel();
                if (fileChannel.isOpen()) {
                    ByteBuffer byteBuffer = ByteBuffer.allocate(50000);
                    ReadableByteChannel readableByteChannel = Channels.newChannel(getMethod.getResponseBodyAsStream());
                    while (readableByteChannel.read(byteBuffer) > 0) {
                        byteBuffer.flip();
                        fileChannel.write(byteBuffer);
                        fileChannel.force(false);
                        byteBuffer.clear();
                    }
                    l = fileChannel.size();
                    fileChannel.close();
                    readableByteChannel.close();
                }
                long l2 = l;
                return l2;
            }
            try {
                if (n == 401 || n == 403) {
                    throw new IllegalStateException("You were not authenticated correctly, did you use the correct credentials?");
                }
                throw new IllegalStateException("Could contact the server at " + httpClient.getHostConfiguration().getHost() + " but received an HTTP error code, " + n);
            }
            catch (IOException iOException) {
                throw new IOException(String.format("The file at %s could not be created.", string));
            }
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }
}

