/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.interceptors.encoding;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.annotations.interception.HeaderDecoratorPrecedence;
import org.jboss.resteasy.annotations.interception.ServerInterceptor;
import org.jboss.resteasy.plugins.interceptors.encoding.ContentEncodingHeaderInterceptor;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.interception.AcceptedByMethod;
import org.jboss.resteasy.spi.interception.MessageBodyWriterContext;

@ServerInterceptor
@Provider
@HeaderDecoratorPrecedence
public class ServerContentEncodingHeaderInterceptor
extends ContentEncodingHeaderInterceptor
implements AcceptedByMethod {
    @Context
    protected HttpRequest request;

    @Override
    public boolean accept(Class declaring, Method method) {
        return this.hasEncodingAnnotation(method.getAnnotations()) || this.hasEncodingAnnotation(declaring.getClass().getAnnotations());
    }

    @Override
    public void write(MessageBodyWriterContext context) throws IOException, WebApplicationException {
        List acceptEncoding = (List)this.request.getHttpHeaders().getRequestHeaders().get((Object)"Accept-Encoding");
        if (acceptEncoding != null) {
            for (String accept : acceptEncoding) {
                if (!accept.contains(this.encoding)) continue;
                super.write(context);
                return;
            }
        }
        context.proceed();
    }
}

