/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.controltask;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.task.ExecutionEngine;
import com.xebialabs.deployit.task.controltask.ControlTask;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ControlTaskService {
    private ExecutionEngine executionEngine;

    @Autowired
    public ControlTaskService(ExecutionEngine executionEngine) {
        this.executionEngine = executionEngine;
    }

    public ControlTask execute(ConfigurationItem configurationItem, String string) {
        MethodDescriptor methodDescriptor = this.getControlTask(configurationItem, string);
        List list = (List)methodDescriptor.invoke(configurationItem);
        ControlTask controlTask = new ControlTask(list);
        String string2 = this.executionEngine.register(controlTask);
        this.executionEngine.execute(string2);
        controlTask.awaitFinish();
        return controlTask;
    }

    private MethodDescriptor getControlTask(ConfigurationItem configurationItem, String string) {
        Type type = configurationItem.getType();
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)type);
        MethodDescriptor methodDescriptor = descriptor.getControlTask(string);
        Checks.checkArgument(methodDescriptor != null, "ConfigurationItem %s of type %s does not have a control task named %s.", configurationItem.getId(), configurationItem.getType(), string);
        return methodDescriptor;
    }
}

