/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task.deployment;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.security.SecurityCallback;
import com.xebialabs.deployit.security.SecurityTemplate;
import com.xebialabs.deployit.task.DeploymentTask;
import java.util.ArrayList;
import java.util.List;
import org.springframework.security.core.Authentication;

public class InitialDeploymentTask
extends DeploymentTask {
    private DeltaSpecification specification;

    public InitialDeploymentTask(DeltaSpecification deltaSpecification, List<? extends DeploymentStep> list, RepositoryService repositoryService, WorkDir workDir) {
        super(list, repositoryService, workDir);
        this.specification = deltaSpecification;
        this.initFromDeployment(deltaSpecification.getDeployedApplication());
    }

    @Override
    public void performPreFlightChecks() {
        Authentication authentication = this.getOwnerCredentials();
        SecurityTemplate.executeAs(authentication, new SecurityCallback<Object>(){

            @Override
            public Object doAs() {
                InitialDeploymentTask.this.repositoryService.checkReferentialIntegrity(InitialDeploymentTask.this.determineRepositoryChanges());
                return null;
            }
        });
    }

    private ChangeSet determineRepositoryChanges() {
        DeployedApplication deployedApplication = this.specification.getDeployedApplication();
        ArrayList arrayList = Lists.newArrayList();
        for (Delta delta : this.specification.getDeltas()) {
            Deployed deployed = delta.getDeployed();
            arrayList.add(deployed);
            deployedApplication.addDeployed(deployed);
        }
        arrayList.add(deployedApplication);
        ChangeSet changeSet = new ChangeSet();
        changeSet.setCreateCis(arrayList);
        return changeSet;
    }

    @Override
    public void doAfterTaskStateChangedToDone() {
        Authentication authentication = this.getOwnerCredentials();
        SecurityTemplate.executeAs(authentication, new SecurityCallback<Object>(){

            @Override
            public Object doAs() {
                InitialDeploymentTask.this.repositoryService.execute(InitialDeploymentTask.this.determineRepositoryChanges());
                return null;
            }
        });
    }

    @Override
    public DeploymentTask.DeploymentType getDeploymentType() {
        return DeploymentTask.DeploymentType.INITIAL;
    }
}

