/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.remoting.vars;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.ReflectionsHolder;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.remoting.vars.DerivedProperty;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VarsConverter {
    private static final String GENERATED_VARIABLE_PREFIX = "_pv";
    private static final String PROPERTIES_VARIABLE_NAME = "_properties";
    private static final char EMBEDDED_OBJECT_SEPARATOR = '_';
    private OverthereConnection connection;
    private Map<String, Object> vars;
    private Class<? extends Annotation> annotationClass;
    private Map<Object, String> alreadyConvertedCis = Maps.newIdentityHashMap();
    private int nextVarNumber = 1;
    private List<String> lines = Lists.newArrayList();
    private boolean uploadArtifactData = true;
    private static final Logger logger = LoggerFactory.getLogger(VarsConverter.class);

    protected VarsConverter(OverthereConnection overthereConnection, Map<String, Object> map, Class<? extends Annotation> clazz) {
        this.connection = overthereConnection;
        this.vars = map;
        this.annotationClass = clazz;
    }

    protected VarsConverter(OverthereConnection overthereConnection, Map<String, Object> map) {
        this(overthereConnection, map, DerivedProperty.class);
    }

    public List<String> convert() {
        TreeSet treeSet = Sets.newTreeSet(this.vars.keySet());
        for (String string : treeSet) {
            Object object = this.vars.get(string);
            this.convertVariable(string, object);
        }
        return this.lines;
    }

    public void setUploadArtifactData(boolean bl) {
        this.uploadArtifactData = bl;
    }

    private void convertVariable(String string, Object object) {
        if (object == null) {
            this.setNullVariable(string);
        } else if (object instanceof Boolean) {
            this.setBooleanVariable(string, (Boolean)object);
        } else if (object instanceof Integer) {
            this.setIntegerVariable(string, (Integer)object);
        } else if (object instanceof Long) {
            this.setLongVariable(string, (Long)object);
        } else if (object instanceof ConfigurationItem) {
            this.alreadyConvertedCis.put(object, string);
            this.appendConfigurationItemVar(string, (ConfigurationItem)object);
        } else if (object instanceof Collection) {
            this.setCollectionOfStringsVariable(string, (Collection)object);
        } else {
            this.setStringVariable(string, object.toString());
        }
    }

    private void appendConfigurationItemVar(String string, ConfigurationItem configurationItem) {
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)configurationItem.getType());
        if (descriptor == null) {
            throw new IllegalArgumentException("Variable " + string + " is a ConfigurationItem of an unknown type: " + configurationItem.getType());
        }
        this.createObject(string);
        this.appendEmbeddedObjectDefinitions(string, descriptor);
        this.appendConfigurationItemVarMetaData(string, configurationItem, descriptor);
        this.appendRegularPropertiesToConfigurationItemVar(string, configurationItem, descriptor);
        this.appendDerivedPropertiesToConfigurationItemVar(string, configurationItem);
        this.appendArtifactPropertiesToConfigurationItemVar(string, configurationItem);
    }

    private void appendEmbeddedObjectDefinitions(String string, Descriptor descriptor) {
        Multimap<String, String> multimap = this.getEmbeddedObjects(string, descriptor);
        this.createEmbeddedObjects(multimap);
    }

    private Multimap<String, String> getEmbeddedObjects(String string, Descriptor descriptor) {
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        for (Object object : descriptor.getPropertyDescriptors()) {
            if (!this.isEmbeddedObjectProperty((PropertyDescriptor)object)) continue;
            arrayListMultimap.put((Object)(string + "." + this.getEmbeddedObjectName((PropertyDescriptor)object)), (Object)this.getEmbeddedPropertyName((PropertyDescriptor)object));
        }
        for (Object object : arrayListMultimap.keySet()) {
            String string2 = ((String)object).substring(0, ((String)object).lastIndexOf("."));
            if (!arrayListMultimap.containsKey((Object)string2)) continue;
            String string3 = ((String)object).substring(((String)object).lastIndexOf(".") + 1);
            arrayListMultimap.get((Object)string2).add(string3);
        }
        return arrayListMultimap;
    }

    private void createEmbeddedObjects(Multimap<String, String> multimap) {
        for (String string : multimap.keySet()) {
            int n = string.lastIndexOf(46);
            this.createObjectAndSetObjectProperty(string.substring(0, n), string.substring(n + 1));
            this.setCollectionOfStringsProperty(string, PROPERTIES_VARIABLE_NAME, multimap.get((Object)string));
        }
    }

    private boolean isEmbeddedObjectProperty(PropertyDescriptor propertyDescriptor) {
        return this.getLastIndexOfEmbeddedObjectSeparator(propertyDescriptor) != -1;
    }

    private String getEmbeddedObjectName(PropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.getName().substring(0, this.getLastIndexOfEmbeddedObjectSeparator(propertyDescriptor)).replace('_', '.');
    }

    private String getEmbeddedPropertyName(PropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.getName().substring(this.getLastIndexOfEmbeddedObjectSeparator(propertyDescriptor) + 1);
    }

    private int getLastIndexOfEmbeddedObjectSeparator(PropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.getName().lastIndexOf(95);
    }

    private void appendConfigurationItemVarMetaData(String string, ConfigurationItem configurationItem, Descriptor descriptor) {
        Object object;
        PropertyDescriptor propertyDescriptor2;
        this.setStringProperty(string, "id", configurationItem.getId());
        this.setStringProperty(string, "name", configurationItem.getName());
        TreeSet treeSet = Sets.newTreeSet();
        treeSet.add("id");
        treeSet.add("name");
        for (PropertyDescriptor propertyDescriptor2 : descriptor.getPropertyDescriptors()) {
            object = !this.isEmbeddedObjectProperty(propertyDescriptor2) ? propertyDescriptor2.getName() : propertyDescriptor2.getName().substring(0, propertyDescriptor2.getName().indexOf(95));
            treeSet.add(object);
        }
        Set set = ReflectionsHolder.getMethodsAnnotatedWith(this.annotationClass);
        propertyDescriptor2 = DescriptorRegistry.getDescriptor((Type)configurationItem.getType());
        object = set.iterator();
        while (object.hasNext()) {
            Method method = (Method)object.next();
            if (!propertyDescriptor2.isAssignableTo(method.getDeclaringClass())) continue;
            treeSet.add(this.getDerivedPropertyName(method));
        }
        this.setCollectionOfStringsProperty(string, PROPERTIES_VARIABLE_NAME, treeSet);
    }

    protected String getDerivedPropertyName(Method method) {
        try {
            Annotation annotation = method.getAnnotation(this.annotationClass);
            Method method2 = this.annotationClass.getMethod("value", new Class[0]);
            return (String)method2.invoke((Object)annotation, new Object[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException("Cannot get name of @DerivedProperty " + method, exception);
        }
    }

    private void appendRegularPropertiesToConfigurationItemVar(String string, ConfigurationItem configurationItem, Descriptor descriptor) {
        block11: for (PropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
            String string2;
            String string3;
            if (!this.isEmbeddedObjectProperty(propertyDescriptor)) {
                string3 = string;
                string2 = propertyDescriptor.getName();
            } else {
                string3 = string + "." + this.getEmbeddedObjectName(propertyDescriptor);
                string2 = this.getEmbeddedPropertyName(propertyDescriptor);
            }
            Object object = propertyDescriptor.get(configurationItem);
            switch (propertyDescriptor.getKind()) {
                case BOOLEAN: {
                    if (object == null) {
                        this.setNullProperty(string3, string2);
                        continue block11;
                    }
                    if (!(object instanceof Boolean)) {
                        throw new IllegalStateException("Property " + propertyDescriptor + " is not a Boolean but a " + object.getClass().getName());
                    }
                    this.setBooleanProperty(string3, string2, (Boolean)object);
                    continue block11;
                }
                case INTEGER: {
                    if (object == null) {
                        this.setNullProperty(string3, string2);
                        continue block11;
                    }
                    if (!(object instanceof Integer)) {
                        throw new IllegalStateException("Property " + propertyDescriptor + " is not an Integer but a " + object.getClass().getName());
                    }
                    this.setIntegerProperty(string3, string2, (Integer)object);
                    continue block11;
                }
                case STRING: 
                case ENUM: {
                    if (object == null) {
                        this.setNullProperty(string3, string2);
                        continue block11;
                    }
                    if (propertyDescriptor.isPassword()) {
                        this.setPasswordProperty(string3, string2, object.toString());
                        continue block11;
                    }
                    this.setStringProperty(string3, string2, object.toString());
                    continue block11;
                }
                case LIST_OF_STRING: {
                    if (object == null) {
                        this.setEmptyCollectionProperty(string3, string2);
                        continue block11;
                    }
                    if (!(object instanceof List)) {
                        throw new IllegalStateException("Property " + propertyDescriptor + " is not a List but a " + object.getClass().getName());
                    }
                    this.setCollectionOfStringsProperty(string3, string2, (List)object);
                    continue block11;
                }
                case SET_OF_STRING: {
                    if (object == null) {
                        this.setEmptyCollectionProperty(string3, string2);
                        continue block11;
                    }
                    if (!(object instanceof Set)) {
                        throw new IllegalStateException("Property " + propertyDescriptor + " is not a Set but a " + object.getClass().getName());
                    }
                    this.setCollectionOfStringsProperty(string3, string2, (Set)object);
                    continue block11;
                }
                case CI: {
                    if (descriptor.isAssignableTo(Type.valueOf(Deployed.class)) && propertyDescriptor.getName().equals("deployable")) {
                        this.setNullProperty(string3, string2);
                        continue block11;
                    }
                    if (object == null) {
                        this.setNullProperty(string3, string2);
                        continue block11;
                    }
                    if (!(object instanceof ConfigurationItem)) {
                        throw new IllegalStateException("Property " + propertyDescriptor + " is not a ConfigurationItem but a " + object.getClass().getName());
                    }
                    this.setCiReferenceProperty(string3, string2, (ConfigurationItem)object);
                    continue block11;
                }
                case LIST_OF_CI: {
                    if (object == null) {
                        this.setEmptyCollectionProperty(string3, string2);
                        continue block11;
                    }
                    if (!(object instanceof List)) {
                        throw new IllegalStateException("Property " + propertyDescriptor + " is not a List but a " + object.getClass().getName());
                    }
                    this.setCollectionOfCiReferencesProperty(string3, string2, (List)object);
                    continue block11;
                }
                case SET_OF_CI: {
                    if (object == null) {
                        this.setEmptyCollectionProperty(string3, string2);
                        continue block11;
                    }
                    if (!(object instanceof Set)) {
                        throw new IllegalStateException("Property " + propertyDescriptor + " is not a Set but a " + object.getClass().getName());
                    }
                    this.setCollectionOfCiReferencesProperty(string3, string2, (Set)object);
                    continue block11;
                }
                case MAP_STRING_STRING: {
                    if (object == null) {
                        this.setEmptyMapProperty(string3, string2);
                        continue block11;
                    }
                    if (!(object instanceof Map)) {
                        throw new IllegalStateException("Property " + propertyDescriptor + " is not a Map but a " + object.getClass().getName());
                    }
                    this.setMapOfStringToStringReferencesProperty(string3, string2, (Map)object);
                    continue block11;
                }
            }
            throw new IllegalStateException("Should not end up here!");
        }
    }

    private void appendDerivedPropertiesToConfigurationItemVar(String string, ConfigurationItem configurationItem) {
        Set set = ReflectionsHolder.getMethodsAnnotatedWith(this.annotationClass);
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)configurationItem.getType());
        for (Method method : set) {
            if (!descriptor.isAssignableTo(method.getDeclaringClass())) continue;
            try {
                this.convertProperty(string, this.getDerivedPropertyName(method), method.invoke((Object)configurationItem, new Object[0]));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException("Method " + method.getName() + " in class " + method.getClass() + " cannot be accessed.", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException("Method " + method.getName() + " in class " + method.getClass() + " cannot be invoked.", invocationTargetException);
            }
        }
    }

    private void convertProperty(String string, String string2, Object object) {
        if (object == null) {
            this.setNullProperty(string, string2);
        } else if (object instanceof Boolean) {
            this.setBooleanProperty(string, string2, (Boolean)object);
        } else if (object instanceof Integer) {
            this.setIntegerProperty(string, string2, (Integer)object);
        } else if (object instanceof Long) {
            this.setIntegerProperty(string, string2, (int)((Long)object).longValue());
        } else if (object instanceof ConfigurationItem) {
            this.setCiReferenceProperty(string, string2, (ConfigurationItem)object);
        } else if (object instanceof Collection) {
            this.setCollectionOfStringsProperty(string, string2, (Collection)object);
        } else {
            this.setStringProperty(string, string2, object.toString());
        }
    }

    private void appendArtifactPropertiesToConfigurationItemVar(String string, ConfigurationItem configurationItem) {
        if (configurationItem instanceof Artifact) {
            if (!this.uploadArtifactData) {
                logger.debug("Setting file property of " + string + " to null because automatic uploading of artifact data is explicitly turned off");
                this.setNullProperty(string, "file");
                return;
            }
            if (!this.vars.containsKey(string)) {
                logger.debug("Setting file property of " + string + " to null because it is an indirectly referenced object");
                this.setNullProperty(string, "file");
                return;
            }
            Artifact artifact = (Artifact)configurationItem;
            Preconditions.checkNotNull((Object)artifact.getFile(), (Object)(artifact + " has a null file"));
            OverthereFile overthereFile = this.connection.getTempFile(artifact.getFile().getName());
            artifact.getFile().copyTo(overthereFile);
            this.setStringProperty(string, "file", overthereFile.getPath());
        }
    }

    protected String getConfigurationItemVariableName(ConfigurationItem configurationItem) {
        if (this.alreadyConvertedCis.containsKey(configurationItem)) {
            return this.alreadyConvertedCis.get(configurationItem);
        }
        String string = this.generateUniqueVariableName();
        this.alreadyConvertedCis.put(configurationItem, string);
        this.appendConfigurationItemVar(string, configurationItem);
        return string;
    }

    protected String generateUniqueVariableName() {
        return GENERATED_VARIABLE_PREFIX + this.nextVarNumber++;
    }

    protected void add(String string) {
        this.lines.add(string);
    }

    protected abstract void setNullVariable(String var1);

    protected abstract void setBooleanVariable(String var1, boolean var2);

    protected abstract void setIntegerVariable(String var1, int var2);

    protected abstract void setLongVariable(String var1, long var2);

    protected abstract void setStringVariable(String var1, String var2);

    protected abstract void setCollectionOfStringsVariable(String var1, Collection<?> var2);

    protected abstract void createObject(String var1);

    protected abstract void setNullProperty(String var1, String var2);

    protected abstract void setEmptyCollectionProperty(String var1, String var2);

    protected abstract void setEmptyMapProperty(String var1, String var2);

    protected abstract void setBooleanProperty(String var1, String var2, boolean var3);

    protected abstract void setIntegerProperty(String var1, String var2, int var3);

    protected abstract void setStringProperty(String var1, String var2, String var3);

    protected abstract void setPasswordProperty(String var1, String var2, String var3);

    protected abstract void setCollectionOfStringsProperty(String var1, String var2, Collection<?> var3);

    protected abstract void setCiReferenceProperty(String var1, String var2, ConfigurationItem var3);

    protected abstract void setCollectionOfCiReferencesProperty(String var1, String var2, Collection<ConfigurationItem> var3);

    protected abstract void setMapOfStringToStringReferencesProperty(String var1, String var2, Map<String, String> var3);

    protected abstract void createObjectAndSetObjectProperty(String var1, String var2);
}

