/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports.widgets;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.rest.api.reports.widgets.DashboardWidgetBase;
import com.xebialabs.deployit.core.rest.api.reports.widgets.Widget;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.DeploymentTaskInfo;
import com.xebialabs.deployit.task.TaskArchive;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

public class DeploymentsDurationFrequencyWidget
extends DashboardWidgetBase {
    private static final String INTERVAL = "interval";
    private static final String DEPLOYMENT_PERCENT = "deploymentPercent";
    private static final String NUM_OF_DEPLOYMENT = "numOfDeployment";
    private final DecimalFormat format = new DecimalFormat("#.##", DecimalFormatSymbols.getInstance(Locale.ENGLISH));

    public DeploymentsDurationFrequencyWidget(TaskArchive taskArchive) {
        this.taskArchive = taskArchive;
    }

    public static final Widget getInstance(TaskArchive taskArchive) {
        return new DeploymentsDurationFrequencyWidget(taskArchive);
    }

    @Override
    public Report getReport(Date date, Date date2) {
        ArchivedTaskSearchParameters archivedTaskSearchParameters = new ArchivedTaskSearchParameters().createdBetween(date.getCalendar(), date2.getCalendar()).thatCompleted();
        Collection collection = this.taskArchive.searchTasksWithoutLoadingSteps(archivedTaskSearchParameters);
        if (collection.size() == 0) {
            return new Report();
        }
        return this.generateReport(collection);
    }

    private Report generateReport(Collection<DeploymentTaskInfo> collection) {
        long l = this.mean(collection);
        long l2 = this.standardDeviation(l, collection);
        List<Long> list = this.clusterLimits(l, l2);
        return this.createDetails(collection, list);
    }

    private long mean(Collection<DeploymentTaskInfo> collection) {
        long l = 0L;
        for (DeploymentTaskInfo deploymentTaskInfo : collection) {
            l += deploymentTaskInfo.getDurationInMillis();
        }
        return l / (long)collection.size();
    }

    private long standardDeviation(long l, Collection<DeploymentTaskInfo> collection) {
        if (collection.size() > 1) {
            long l2 = 0L;
            for (DeploymentTaskInfo deploymentTaskInfo : collection) {
                long l3 = deploymentTaskInfo.getDurationInMillis() - l;
                l2 += l3 * l3;
            }
            return (long)Math.sqrt(l2 / (long)(collection.size() - 1));
        }
        return 0L;
    }

    private List<Long> clusterLimits(long l, long l2) {
        ArrayList arrayList = Lists.newArrayList();
        if (l2 > 0L && l - l2 - l2 > 0L) {
            arrayList.add(l - l2 - l2);
        }
        if (l2 > 0L && l - l2 > 0L) {
            arrayList.add(l - l2);
        }
        arrayList.add(l);
        if (l2 > 0L) {
            arrayList.add(l + l2);
            arrayList.add(l + l2 + l2);
        }
        return arrayList;
    }

    private Report createDetails(Collection<DeploymentTaskInfo> collection, List<Long> list) {
        Report report = new Report();
        int[] nArray = this.cluster(collection, list);
        int n = collection.size();
        if (n > 1) {
            Report.ReportLine reportLine = report.addLine();
            reportLine.addValue(INTERVAL, (Object)("<" + this.formatToMins(Math.round(list.get(0).longValue()))));
            reportLine.addValue(DEPLOYMENT_PERCENT, (Object)this.format.format(this.getPercentage(nArray[0], n)));
            reportLine.addValue(NUM_OF_DEPLOYMENT, (Object)this.format.format(nArray[0]));
        }
        for (int i = 1; i < list.size(); ++i) {
            Report.ReportLine reportLine = report.addLine();
            reportLine.addValue(INTERVAL, (Object)(this.formatToMins(Math.round(list.get(i - 1).longValue())) + " - " + this.formatToMins(list.get(i))));
            reportLine.addValue(DEPLOYMENT_PERCENT, (Object)this.format.format(this.getPercentage(nArray[i], n)));
            reportLine.addValue(NUM_OF_DEPLOYMENT, (Object)this.format.format(nArray[i]));
        }
        Report.ReportLine reportLine = report.addLine();
        reportLine.addValue(INTERVAL, (Object)(">" + this.formatToMins(list.get(list.size() - 1))));
        reportLine.addValue(DEPLOYMENT_PERCENT, (Object)this.format.format(this.getPercentage(nArray[nArray.length - 1], n)));
        reportLine.addValue(NUM_OF_DEPLOYMENT, (Object)this.format.format(nArray[nArray.length - 1]));
        return report;
    }

    private int[] cluster(Collection<DeploymentTaskInfo> collection, List<Long> list) {
        int[] nArray = new int[list.size() + 1];
        for (DeploymentTaskInfo deploymentTaskInfo : collection) {
            boolean bl = true;
            for (int i = 0; i < list.size(); ++i) {
                Long l = list.get(i);
                if (deploymentTaskInfo.getDurationInMillis() >= l) continue;
                int n = i;
                nArray[n] = nArray[n] + 1;
                bl = false;
                break;
            }
            if (!bl) continue;
            int n = list.size();
            nArray[n] = nArray[n] + 1;
        }
        return nArray;
    }
}

