/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.udm.base;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import java.util.Map;
import java.util.regex.Pattern;

@Metadata(virtual=true)
public class BaseConfigurationItem
implements ConfigurationItem,
Comparable<BaseConfigurationItem> {
    protected String id = String.valueOf(System.identityHashCode(this));
    protected Type type = Type.valueOf(this.getClass());
    protected Map<String, Object> syntheticProperties = Maps.newHashMap();

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    @Override
    public String getName() {
        int n = this.id.lastIndexOf(47);
        if (n > -1) {
            return this.id.substring(n + 1);
        }
        return this.id;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BaseConfigurationItem)) {
            return false;
        }
        BaseConfigurationItem baseConfigurationItem = (BaseConfigurationItem)object;
        return this.getId().equals(baseConfigurationItem.getId());
    }

    @Override
    public int compareTo(BaseConfigurationItem baseConfigurationItem) {
        return this.getId().compareTo(baseConfigurationItem.getId());
    }

    public String toString() {
        if (this.id == null) {
            return this.getClass().getName() + "[id = null]";
        }
        if (Pattern.matches("[ '\"]", this.id)) {
            return "\"" + this.id + "\"";
        }
        return this.id;
    }

    @Override
    @Deprecated
    public Map<String, Object> getSyntheticProperties() {
        return this.syntheticProperties;
    }

    @Override
    @Deprecated
    public <T> T getSyntheticProperty(String string) {
        return (T)this.syntheticProperties.get(string);
    }

    @Deprecated
    public boolean hasSyntheticProperty(String string) {
        return this.syntheticProperties.containsKey(string);
    }

    @Override
    @Deprecated
    public <T> void putSyntheticProperty(String string, T t) {
        this.syntheticProperties.put(string, t);
    }

    @Deprecated
    public void putSyntheticProperties(Map<String, String> map) {
        this.syntheticProperties.putAll(map);
    }

    @Deprecated
    public void setSyntheticProperties(Map<String, Object> map) {
        this.syntheticProperties = map;
    }

    @Override
    public <T> T getProperty(String string) {
        return (T)this.getPropertyDescriptor(string).get(this);
    }

    @Override
    public boolean hasProperty(String string) {
        return this.type.getDescriptor().getPropertyDescriptor(string) != null;
    }

    @Override
    public <T> void setProperty(String string, T t) {
        this.getPropertyDescriptor(string).set(this, t);
    }

    protected PropertyDescriptor getPropertyDescriptor(String string) {
        PropertyDescriptor propertyDescriptor = this.type.getDescriptor().getPropertyDescriptor(string);
        Preconditions.checkArgument((propertyDescriptor != null ? 1 : 0) != 0, (String)"Type %s has no property %s", (Object[])new Object[]{this.type, string});
        return propertyDescriptor;
    }
}

