/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.validation;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import java.util.Set;

@Retention(value=RetentionPolicy.RUNTIME)
@Rule(clazz=Validator.class, type="placeholders")
@Target(value={ElementType.TYPE})
public @interface Placeholders {

    public static class Validator
    implements com.xebialabs.deployit.plugin.api.validation.Validator<Deployed<?, ?>> {
        @Override
        public void validate(Deployed<?, ?> deployed, ValidationContext validationContext) {
            if (!deployed.hasProperty("placeholders")) {
                return;
            }
            Map map = (Map)deployed.getProperty("placeholders");
            this.validateAllPlaceholdersSet(map, validationContext);
            if (deployed.getDeployable() != null) {
                Object obj = deployed.getDeployable();
                if (!obj.hasProperty("placeholders")) {
                    validationContext.error("Deployed %s has placeholders but the Deployable not.", deployed.getId());
                } else {
                    Set set = (Set)obj.getProperty("placeholders");
                    this.validatePlaceholdersAllPresent(set, map, validationContext);
                }
            }
        }

        private void validatePlaceholdersAllPresent(Set<String> set, Map<String, String> map, ValidationContext validationContext) {
            Set<String> set2 = map.keySet();
            this.wrongKeys((Set<String>)Sets.difference(set, set2), validationContext, "Deployable contains placeholder %s which is not defined in deployed");
            this.wrongKeys((Set<String>)Sets.difference(set2, set), validationContext, "Deployed contains placeholder %s which was not found in deployable");
        }

        private void wrongKeys(Set<String> set, ValidationContext validationContext, String string) {
            for (String string2 : set) {
                validationContext.error(string, string2);
            }
        }

        private void validateAllPlaceholdersSet(Map<String, String> map, ValidationContext validationContext) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (entry.getValue() != null && !entry.getValue().trim().isEmpty()) continue;
                validationContext.error("Placeholders [%s] doesn't have a value.", entry.getKey());
            }
        }
    }
}

