/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere;

import com.xebialabs.overthere.RuntimeIOException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

public enum OperatingSystemFamily {
    WINDOWS('\\', ';', "\r\n", "&&", ".bat", "C:\\windows\\temp"),
    UNIX('/', ':', "\n", ";", ".sh", "/tmp");

    private final String fileSeparator;
    private final char fileSeparatorChar;
    private final String pathSeparator;
    private final char pathSeparatorChar;
    private final String lineSeparator;
    private final String commandSeparator;
    private final String scriptExtension;
    private final String defaultTemporaryDirectoryPath;

    private OperatingSystemFamily(char c, char c2, String string2, String string3, String string4, String string5) {
        this.scriptExtension = string4;
        this.lineSeparator = string2;
        this.defaultTemporaryDirectoryPath = string5;
        this.fileSeparator = String.valueOf(c);
        this.fileSeparatorChar = c;
        this.pathSeparator = String.valueOf(c2);
        this.pathSeparatorChar = c2;
        this.commandSeparator = string3;
    }

    public static OperatingSystemFamily getLocalHostOperatingSystemFamily() {
        return System.getProperty("os.name").startsWith("Windows") ? WINDOWS : UNIX;
    }

    public String convertText(String string) {
        if (string == null) {
            return null;
        }
        String string2 = this.getLineSeparator();
        try {
            String string3;
            StringBuilder stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string3).append(string2);
            }
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("Unable to read String", iOException);
        }
    }

    public String getFileSeparator() {
        return this.fileSeparator;
    }

    public char getFileSeparatorChar() {
        return this.fileSeparatorChar;
    }

    public String getPathSeparator() {
        return this.pathSeparator;
    }

    public char getPathSeparatorChar() {
        return this.pathSeparatorChar;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public String getCommandSeparator() {
        return this.commandSeparator;
    }

    public String getScriptExtension() {
        return this.scriptExtension;
    }

    public String getDefaultTemporaryDirectoryPath() {
        return this.defaultTemporaryDirectoryPath;
    }
}

