/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.jetty;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpMethodOverrideServletRequest
extends HttpServletRequestWrapper {
    public static final String DEFAULT_HEADER = "X-HTTP-Method-Override";
    private final String methodOverrideHeader;
    private transient String method;
    private static Logger logger = LoggerFactory.getLogger(HttpMethodOverrideServletRequest.class);

    public HttpMethodOverrideServletRequest(HttpServletRequest httpServletRequest, String string) {
        super(httpServletRequest);
        this.methodOverrideHeader = string;
    }

    public String getMethod() {
        if (this.method == null) {
            this.method = this.resolveMethod();
        }
        return this.method;
    }

    protected String resolveMethod() {
        String string;
        String string2 = this.getHeader(this.methodOverrideHeader);
        if (string2 != null) {
            string = string2;
            logger.debug("Overriding " + super.getMethod() + " request to be a " + string + " request because a " + this.methodOverrideHeader + " header was present");
        } else {
            string = super.getMethod();
            logger.debug("Not overriding a " + string + " request");
        }
        return string;
    }
}

