/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cmd.deployed;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployed;
import com.xebialabs.deployit.plugin.cmd.ci.Command;
import com.xebialabs.deployit.plugin.cmd.step.ExecuteCommandStep;
import com.xebialabs.deployit.plugin.cmd.step.NoCommandStep;
import com.xebialabs.deployit.plugin.file.File;
import com.xebialabs.deployit.plugin.overthere.Host;
import java.util.Set;

@Metadata(description="Command deployed to a Host")
public class DeployedCommand
extends BaseDeployed<Command, Host> {
    @Property(description="Order of the command", defaultValue="50")
    private int order = 50;
    @Property(required=false, description="Artifacts that the command depends on")
    private Set<File> dependencies = Sets.newHashSet();
    @Property(description="Command line to execute on host. Dependent artifacts can be referred to using ${artifact name}.", required=false, size=Property.Size.LARGE)
    private String commandLine;
    @Property(required=false, description="Command to execute when undeploying command")
    private Command undoCommand;
    @Property(required=false, description="Indicates whether the undoCommand should be run on an upgrade")
    private boolean runUndoCommandOnUpgrade = true;
    @Property(required=false, isTransient=true, description="Forces the command to be rerun.")
    private boolean rerunCommand;

    @Create
    public void executeCreateCommand(DeploymentPlanningContext deploymentPlanningContext) {
        deploymentPlanningContext.addStep((DeploymentStep)new ExecuteCommandStep(this.order, this));
    }

    @Modify
    public void executeModifyCommand(DeploymentPlanningContext deploymentPlanningContext) {
        if (this.undoCommand != null && this.runUndoCommandOnUpgrade) {
            DeployedCommand deployedCommand = this.createDeployedUndoCommand();
            deploymentPlanningContext.addStep((DeploymentStep)new ExecuteCommandStep(this.undoCommand.getOrder(), deployedCommand));
        }
        deploymentPlanningContext.addStep((DeploymentStep)new ExecuteCommandStep(this.order, this));
    }

    private DeployedCommand createDeployedUndoCommand() {
        DeployedCommand deployedCommand = new DeployedCommand();
        deployedCommand.setCommandLine(this.undoCommand.getCommandLine());
        deployedCommand.setDependencies(this.undoCommand.getDependencies());
        deployedCommand.setOrder(this.undoCommand.getOrder());
        deployedCommand.setContainer(this.getContainer());
        deployedCommand.setDeployable((Deployable)this.undoCommand);
        deployedCommand.setId(this.undoCommand.getId());
        deployedCommand.setSyntheticProperties(this.getSyntheticProperties());
        return deployedCommand;
    }

    @Destroy
    public void destroyCommand(DeploymentPlanningContext deploymentPlanningContext) {
        if (this.undoCommand != null) {
            DeployedCommand deployedCommand = this.createDeployedUndoCommand();
            deploymentPlanningContext.addStep((DeploymentStep)new ExecuteCommandStep(this.undoCommand.getOrder(), deployedCommand));
        } else {
            deploymentPlanningContext.addStep((DeploymentStep)new NoCommandStep(this.order, this));
        }
    }

    public Set<File> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(Set<File> set) {
        this.dependencies = set;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int n) {
        this.order = n;
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public void setCommandLine(String string) {
        this.commandLine = string;
    }

    public Command getUndoCommand() {
        return this.undoCommand;
    }

    public void setUndoCommand(Command command) {
        this.undoCommand = command;
    }

    public boolean isRunUndoCommandOnUpgrade() {
        return this.runUndoCommandOnUpgrade;
    }

    public void setRunUndoCommandOnUpgrade(boolean bl) {
        this.runUndoCommandOnUpgrade = bl;
    }

    public boolean isRerunCommand() {
        return this.rerunCommand;
    }

    public void setRerunCommand(boolean bl) {
        this.rerunCommand = bl;
    }
}

