/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.api.dto;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.xebialabs.deployit.core.api.dto.AbstractDTO;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="security-settings")
public class PrincipalPermissions
extends AbstractDTO {
    @XmlAttribute
    private String username;
    @XmlElement
    private List<PrincipalPermission> permissions = Lists.newArrayList();

    public PrincipalPermissions() {
    }

    public PrincipalPermissions(String string, Multimap<String, String> multimap) {
        this.username = string;
        if (multimap != null) {
            this.convert(multimap);
        }
    }

    private void convert(Multimap<String, String> multimap) {
        for (String string : multimap.keySet()) {
            this.permissions.add(new PrincipalPermission(string, Lists.newArrayList((Iterable)multimap.get((Object)string))));
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public boolean hasPermissions() {
        return !this.permissions.isEmpty();
    }

    public boolean hasPermission(final String string) {
        return !Collections2.filter(this.permissions, (Predicate)new Predicate<PrincipalPermission>(){

            public boolean apply(PrincipalPermission principalPermission) {
                return Strings.isNullOrEmpty((String)principalPermission.node) && principalPermission.permissions.contains(string);
            }
        }).isEmpty();
    }

    public boolean hasPermission(final String string, final String string2) {
        return !Collections2.filter(this.permissions, (Predicate)new Predicate<PrincipalPermission>(){

            public boolean apply(PrincipalPermission principalPermission) {
                return (string == principalPermission.node || string != null && string.equals(principalPermission.node)) && principalPermission.permissions.contains(string2);
            }
        }).isEmpty();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.permissions == null || this.permissions.isEmpty()) {
            stringBuilder.append("There are no permissions set for the requested user, or the requested user doesn't exist!\n");
        } else {
            for (PrincipalPermission principalPermission : this.permissions) {
                if (principalPermission.node.equals("")) {
                    stringBuilder.append(String.format("\nGranted global permissions:'\n", new Object[0]));
                    this.appendPermissions(stringBuilder, principalPermission.permissions);
                    continue;
                }
                stringBuilder.append(String.format("\nGranted permissions on node '%s':\n", principalPermission.node));
                this.appendPermissions(stringBuilder, principalPermission.permissions);
            }
        }
        return stringBuilder.toString();
    }

    private void appendPermissions(StringBuilder stringBuilder, List<String> list) {
        for (String string : list) {
            stringBuilder.append(String.format("\t- %s\n", string));
        }
    }

    @XmlRootElement
    private static class PrincipalPermission {
        @XmlElement
        private String node;
        @XmlElement
        private List<String> permissions = Lists.newArrayList();

        private PrincipalPermission(String string, List<String> list) {
            this.node = string;
            this.permissions = list;
        }

        public PrincipalPermission() {
        }
    }
}

