/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.file.deployed;

import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployedArtifact;
import com.xebialabs.deployit.plugin.generic.ci.Container;
import com.xebialabs.deployit.plugin.generic.deployed.CopiedArtifact;
import com.xebialabs.deployit.plugin.overthere.Host;

@Metadata(virtual=true, description="Abstract deployed that can target any DeployableArtifact to a Host.")
public class DeployedArtifactOnHost<D extends DeployableArtifact>
extends BaseDeployedArtifact<D, Host> {
    @Property(description="Path to which artifact must be copied to on the host.")
    private String targetPath;
    @Property(required=false, defaultValue="true", description="Is the targetPath shared by others on the host. When true, the targetPath is not deleted during undeployment; only the artifacts copied to it.")
    private boolean targetPathShared;
    @Property(required=false, defaultValue="false", description="Create the targetPath on the host if it does not exist.")
    private boolean createTargetPath;
    @Property(required=false, description="Name of the artifact on the host.")
    private String targetFileName;

    private CopiedArtifact<D> createDelegate() {
        CopiedArtifact copiedArtifact = new CopiedArtifact();
        copiedArtifact.setSyntheticProperties(this.getSyntheticProperties());
        copiedArtifact.setPlaceholders(this.getPlaceholders());
        copiedArtifact.setFile(this.getFile());
        copiedArtifact.setId(this.getId());
        Container container = new Container();
        container.setHost((Host)this.getContainer());
        container.setId(((Host)this.getContainer()).getId());
        copiedArtifact.setContainer((com.xebialabs.deployit.plugin.api.udm.Container)container);
        copiedArtifact.setDeployable(this.getDeployable());
        copiedArtifact.setCreateOrder(60);
        copiedArtifact.setDestroyOrder(40);
        copiedArtifact.setCreateTargetDirectory(this.isCreateTargetPath());
        copiedArtifact.setTargetFile(this.getTargetFileName());
        copiedArtifact.setTargetDirectory(this.getTargetPath());
        copiedArtifact.setTargetDirectoryShared(this.isTargetPathShared());
        copiedArtifact.setUseDescriptionGeneratedByStep(true);
        return copiedArtifact;
    }

    @Create
    public void executeCreate(DeploymentPlanningContext deploymentPlanningContext) {
        CopiedArtifact<D> copiedArtifact = this.createDelegate();
        copiedArtifact.executeCreate(deploymentPlanningContext);
    }

    @Modify
    public void executeModify(DeploymentPlanningContext deploymentPlanningContext, Delta delta) {
        DeployedArtifactOnHost deployedArtifactOnHost = (DeployedArtifactOnHost)delta.getPrevious();
        deployedArtifactOnHost.executeDestroy(deploymentPlanningContext);
        this.executeCreate(deploymentPlanningContext);
    }

    @Destroy
    public void executeDestroy(DeploymentPlanningContext deploymentPlanningContext) {
        CopiedArtifact<D> copiedArtifact = this.createDelegate();
        copiedArtifact.executeDestroy(deploymentPlanningContext);
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public void setTargetPath(String string) {
        this.targetPath = string;
    }

    public boolean isTargetPathShared() {
        return this.targetPathShared;
    }

    public void setTargetPathShared(boolean bl) {
        this.targetPathShared = bl;
    }

    public boolean isCreateTargetPath() {
        return this.createTargetPath;
    }

    public void setCreateTargetPath(boolean bl) {
        this.createTargetPath = bl;
    }

    public String getTargetFileName() {
        return this.targetFileName;
    }

    public void setTargetFileName(String string) {
        this.targetFileName = string;
    }
}

