/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.deployed;

import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.generic.deployed.AbstractDeployedArtifact;
import com.xebialabs.deployit.plugin.generic.step.ArtifactDeleteStep;
import com.xebialabs.deployit.plugin.generic.step.TemplateArtifactCopyStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;

@Metadata(virtual=true, description="A template deployed to a generic container")
public class ProcessedTemplate<D extends Deployable>
extends AbstractDeployedArtifact<D> {
    @Property(hidden=true, required=true, description="Classpath to the freemarker template used to generate the content of the final text base artifact.")
    private String template;

    @Create
    public void executeCreate(DeploymentPlanningContext deploymentPlanningContext) {
        deploymentPlanningContext.addStep((DeploymentStep)this.createTemplateArtifactCopyStep());
    }

    @Modify
    public void executeModify(DeploymentPlanningContext deploymentPlanningContext, Delta delta) {
        ProcessedTemplate processedTemplate = (ProcessedTemplate)delta.getPrevious();
        processedTemplate.executeDestroy(deploymentPlanningContext);
        this.executeCreate(deploymentPlanningContext);
    }

    @Destroy
    public void executeDestroy(DeploymentPlanningContext deploymentPlanningContext) {
        deploymentPlanningContext.addStep((DeploymentStep)this.createArtifactDeleteStep());
    }

    protected TemplateArtifactCopyStep createTemplateArtifactCopyStep() {
        TemplateArtifactCopyStep templateArtifactCopyStep = new TemplateArtifactCopyStep(this.getCreateOrder(), (HostContainer)this.getContainer(), this.getDeployedAsFreeMarkerContext(), this.getTemplate(), this.getTargetDirectory());
        templateArtifactCopyStep.setCreateTargetPath(this.isCreateTargetDirectory());
        templateArtifactCopyStep.setTargetFileName(this.resolveTargetFileName());
        templateArtifactCopyStep.setSourceFileDescription(this.getDeployable().getName());
        templateArtifactCopyStep.setDescription(this.getDescription(this.getCreateVerb()));
        return templateArtifactCopyStep;
    }

    protected ArtifactDeleteStep createArtifactDeleteStep() {
        ArtifactDeleteStep artifactDeleteStep = new ArtifactDeleteStep(this.getDestroyOrder(), (HostContainer)this.getContainer(), this.getTargetDirectory());
        artifactDeleteStep.setTargetDirectoryShared(this.isTargetDirectoryShared());
        artifactDeleteStep.setTargetFile(this.resolveTargetFileName());
        artifactDeleteStep.setDescription(this.getDescription(this.getDestroyVerb()));
        return artifactDeleteStep;
    }

    public String getTemplate() {
        return this.resolveExpression(this.template);
    }

    public void setTemplate(String string) {
        this.template = string;
    }
}

