/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cmd.step;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.cmd.deployed.DeployedCommand;
import com.xebialabs.deployit.plugin.file.File;
import com.xebialabs.deployit.plugin.overthere.ExecutionContextOverthereProcessOutputHandler;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.Overthere;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcessOutputHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExecuteCommandStep
implements DeploymentStep {
    private DeployedCommand command;
    private transient OverthereConnection localConn;
    private transient OverthereConnection remoteConn;
    private transient ExecutionContext ctx;
    private Pattern placeHolderPattern = Pattern.compile("\\$\\{(.*)\\}");
    private int order;

    public ExecuteCommandStep(int n, DeployedCommand deployedCommand) {
        this.order = n;
        this.command = deployedCommand;
        this.validateCommandLineDependencyPlaceholders();
    }

    private Iterable<String> getCommandLineArgs() {
        String string = this.command.getCommandLine();
        if (!Strings.nullToEmpty((String)string).trim().isEmpty()) {
            string = string.replace('\n', ' ');
            return Splitter.on((char)' ').split((CharSequence)string);
        }
        return Lists.newArrayList();
    }

    private void validateCommandLineDependencyPlaceholders() {
        for (String string : this.getCommandLineArgs()) {
            String string2 = this.extractDependencyRefFromPlaceholderArg(string);
            if (string2 == null) continue;
            boolean bl = false;
            for (File file : this.command.getDependencies()) {
                if (!file.getName().equals(string2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            throw new IllegalArgumentException("Placeholder arg " + string + " does not refer to a valid dependency");
        }
    }

    private String extractDependencyRefFromPlaceholderArg(String string) {
        Matcher matcher = this.placeHolderPattern.matcher(string);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public String getDescription() {
        return "Execute " + this.command.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Step.Result execute(DeploymentExecutionContext deploymentExecutionContext) throws Exception {
        try {
            this.ctx = deploymentExecutionContext;
            Map<String, OverthereFile> map = this.uploadDependencies();
            CmdLine cmdLine = this.resolveCommandLine(map);
            ExecutionContextOverthereProcessOutputHandler executionContextOverthereProcessOutputHandler = new ExecutionContextOverthereProcessOutputHandler((ExecutionContext)deploymentExecutionContext);
            deploymentExecutionContext.logOutput("Executing command line : " + cmdLine.toCommandLine(((Host)this.command.getContainer()).getOs(), true));
            int n = this.getRemoteConnection().execute((OverthereProcessOutputHandler)executionContextOverthereProcessOutputHandler, cmdLine);
            if (n != 0) {
                deploymentExecutionContext.logError("Command failed with return code " + n);
                Step.Result result = Step.Result.Fail;
                return result;
            }
        }
        finally {
            this.disconnect();
        }
        return Step.Result.Success;
    }

    private Map<String, OverthereFile> uploadDependencies() {
        HashMap hashMap = Maps.newHashMap();
        if (this.command.getDependencies() == null || this.command.getDependencies().isEmpty()) {
            return hashMap;
        }
        OverthereFile overthereFile = this.getRemoteConnection().getTempFile("exec_cmd", ".tmp");
        overthereFile.mkdir();
        this.ctx.logOutput("Uploading " + this.command.getDependencies().size() + " dependent files to " + overthereFile.getPath());
        for (File file : this.command.getDependencies()) {
            String string = file.getName();
            OverthereFile overthereFile2 = overthereFile.getFile(string);
            OverthereFile overthereFile3 = this.getLocalConnection().getFile(file.getFile().getPath());
            overthereFile3.copyTo(overthereFile2);
            this.ctx.logOutput("Uploaded " + string);
            hashMap.put(string, overthereFile2);
        }
        this.ctx.logOutput("Uploading done.");
        return hashMap;
    }

    private CmdLine resolveCommandLine(Map<String, OverthereFile> map) {
        CmdLine cmdLine = new CmdLine();
        for (String string : this.getCommandLineArgs()) {
            String string2 = this.extractDependencyRefFromPlaceholderArg(string);
            if (string2 != null) {
                cmdLine.addArgument(map.get(string2).getPath());
                continue;
            }
            cmdLine.addArgument(string);
        }
        return cmdLine;
    }

    private OverthereConnection getLocalConnection() {
        if (this.localConn == null) {
            this.localConn = Overthere.getConnection((String)"local", (ConnectionOptions)new ConnectionOptions());
        }
        return this.localConn;
    }

    private OverthereConnection getRemoteConnection() {
        if (this.remoteConn == null) {
            this.remoteConn = ((Host)this.command.getContainer()).getConnection();
        }
        return this.remoteConn;
    }

    private void disconnect() {
        if (this.localConn != null) {
            this.localConn.close();
        }
        if (this.remoteConn != null) {
            this.remoteConn.close();
        }
        this.localConn = null;
        this.remoteConn = null;
    }

    public int getOrder() {
        return this.order;
    }
}

