/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SshInteractiveSudoPasswordHandlingStream
extends FilterInputStream {
    private final OutputStream remoteStdin;
    private final byte[] passwordBytes;
    private final String passwordRegex;
    private final Pattern passwordPattern;
    private final StringBuilder receivedOutputBuffer = new StringBuilder();
    private boolean onFirstLine = true;
    private static Logger logger = LoggerFactory.getLogger(SshInteractiveSudoPasswordHandlingStream.class);

    protected SshInteractiveSudoPasswordHandlingStream(InputStream inputStream, OutputStream outputStream, String string, String string2) {
        super(inputStream);
        this.remoteStdin = outputStream;
        this.passwordBytes = (string + "\r\n").getBytes();
        this.passwordRegex = string2;
        this.passwordPattern = Pattern.compile(this.passwordRegex);
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        if (n > -1) {
            this.handleChar((char)n);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 > -1) {
            for (int i = 0; i < n3; ++i) {
                this.handleChar((char)byArray[n + i]);
            }
        }
        return n3;
    }

    private void handleChar(char c) {
        if (this.onFirstLine) {
            logger.trace("Received: {}", (Object)Character.valueOf(c));
            if (c == '\n') {
                this.onFirstLine = false;
            } else {
                String string;
                this.receivedOutputBuffer.append(c);
                if (c == this.passwordRegex.charAt(this.passwordRegex.length() - 1) && this.passwordPattern.matcher(string = this.receivedOutputBuffer.toString()).matches()) {
                    logger.info("Found password prompt in first line of output: {}", (Object)string);
                    try {
                        this.remoteStdin.write(this.passwordBytes);
                        this.remoteStdin.flush();
                        logger.debug("Sent password");
                    }
                    catch (IOException iOException) {
                        logger.error("Cannot send password", (Throwable)iOException);
                    }
                }
            }
        }
    }
}

