/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports.widgets;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.rest.api.reports.widgets.Widget;
import com.xebialabs.deployit.task.TaskArchive;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;

abstract class DashboardWidgetBase
implements Widget {
    protected TaskArchive taskArchive;
    final SimpleDateFormat monthFormat = new SimpleDateFormat("MMM", Locale.ENGLISH);

    DashboardWidgetBase() {
    }

    protected final double getPercentage(double d, double d2) {
        Preconditions.checkArgument((d <= d2 ? 1 : 0) != 0, (Object)("Number of deplyments in a state passed to the percentage function cannot be greater than total number of deployments! numOfDeployment :" + d + "totalDeployment:" + d2));
        return d2 == 0.0 ? 0.0 : d / d2 * 100.0;
    }

    final String formatToMinsAndSecs(long l) {
        long l2 = TimeUnit.MILLISECONDS.toSeconds(l) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(l));
        String string = String.valueOf(l2);
        if (l2 < 10L) {
            string = "0" + string;
        }
        return String.format("%d:%s", TimeUnit.MILLISECONDS.toMinutes(l), string);
    }

    protected final String formatToMins(long l) {
        long l2 = TimeUnit.MILLISECONDS.toMinutes(l);
        long l3 = TimeUnit.MILLISECONDS.toSeconds(l) - TimeUnit.MINUTES.toSeconds(l2);
        if (l3 >= 30L) {
            ++l2;
        }
        return String.format("%d", l2);
    }

    protected <T> Map<String, T> initializeMap(Date date, Date date2, Function<String, T> function) {
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
        Calendar calendar = (Calendar)date.getCalendar().clone();
        calendar.set(5, 1);
        Calendar calendar2 = (Calendar)date2.getCalendar().clone();
        calendar2.set(5, 1);
        while (calendar.compareTo(calendar2) <= 0) {
            String string = this.monthFormat.format(calendar.getTime());
            linkedHashMap.put(string, function.apply((Object)string));
            calendar.add(2, 1);
        }
        return linkedHashMap;
    }
}

