/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.powershell;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployed;
import com.xebialabs.deployit.plugin.powershell.PowerShellContainer;
import com.xebialabs.deployit.plugin.powershell.PowerShellDeploymentStep;
import java.util.HashMap;
import java.util.Map;

@Metadata(virtual=true)
public class BasePowerShellDeployed<D extends Deployable, C extends PowerShellContainer>
extends BaseDeployed<D, C> {
    @Property(required=false, hidden=true, defaultValue="false", description="If set to true, the deployed application CI is exposed to the PowerShell script.")
    private boolean exposeDeployedApplication;

    protected boolean addStep(DeploymentPlanningContext deploymentPlanningContext, int n, String string, String string2) {
        return this.addStep(deploymentPlanningContext, n, string, string2, true);
    }

    protected boolean addStep(DeploymentPlanningContext deploymentPlanningContext, int n, String string, String string2, boolean bl) {
        if (string != null) {
            PowerShellDeploymentStep powerShellDeploymentStep = new PowerShellDeploymentStep(n, (PowerShellContainer)this.getContainer(), string, this.getVars(deploymentPlanningContext.getDeployedApplication()), this.getDescription(string2));
            powerShellDeploymentStep.setUploadArtifactData(bl);
            deploymentPlanningContext.addStep((DeploymentStep)powerShellDeploymentStep);
            return true;
        }
        return false;
    }

    protected Map<String, Object> getVars(DeployedApplication deployedApplication) {
        HashMap hashMap = Maps.newHashMap();
        hashMap.put("deployed", this);
        if (this.exposeDeployedApplication) {
            Preconditions.checkNotNull((Object)deployedApplication, (Object)"deployedApplication is null");
            hashMap.put("deployedApplication", deployedApplication);
        }
        return hashMap;
    }

    protected String getDescription(String string) {
        return String.format("%s %s on %s", string, this.getName(), ((PowerShellContainer)this.getContainer()).getName());
    }

    public boolean getExposeDeployedApplication() {
        return this.exposeDeployedApplication;
    }

    public void setExposeDeployedApplication(boolean bl) {
        this.exposeDeployedApplication = bl;
    }
}

