/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugins.releaseauth.step;

import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.plugins.releaseauth.ReleaseCondition;
import java.util.Set;

public class LogReleaseConditionsStep
implements DeploymentStep {
    private final Set<ReleaseCondition> conditions;
    private Version deploymentPackage;
    private final int order;

    public LogReleaseConditionsStep(int n, Set<ReleaseCondition> set, Version version) {
        this.conditions = set;
        this.deploymentPackage = version;
        this.order = n;
    }

    public Step.Result execute(DeploymentExecutionContext deploymentExecutionContext) throws Exception {
        deploymentExecutionContext.logOutput(" release conditions:");
        deploymentExecutionContext.logOutput(this.buildValidatedConditionsMessage());
        return Step.Result.Success;
    }

    private String buildValidatedConditionsMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        for (ReleaseCondition releaseCondition : this.conditions) {
            stringBuilder.append(String.format("Condition '%s': OK%n", releaseCondition));
        }
        return stringBuilder.toString();
    }

    public String getDescription() {
        return String.format("Logging release authorization for deployment of '%s'", this.deploymentPackage);
    }

    public int getOrder() {
        return this.order;
    }
}

