/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.api.jaxb;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="map")
public class MapMapElement {
    private MapEntry[] mapEntries = new MapEntry[0];

    public MapMapElement() {
    }

    public MapMapElement(Map<String, String> map) {
        ArrayList arrayList = Lists.newArrayList();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            arrayList.add(new MapEntry(entry));
        }
        this.mapEntries = arrayList.toArray(new MapEntry[arrayList.size()]);
    }

    @XmlElement(name="map")
    public MapEntry[] getMapEntries() {
        return this.mapEntries;
    }

    public void setMapEntries(MapEntry[] mapEntryArray) {
        this.mapEntries = mapEntryArray;
    }

    @XmlTransient
    public Map<String, String> getMap() {
        HashMap hashMap = Maps.newHashMap();
        for (MapEntry mapEntry : this.mapEntries) {
            hashMap.put(mapEntry.getKey(), mapEntry.getValue());
        }
        return hashMap;
    }

    @XmlRootElement
    public static class MapEntry {
        private String key;
        private String value;

        public MapEntry() {
        }

        public MapEntry(Map.Entry<String, String> entry) {
            this.key = entry.getKey();
            this.value = entry.getValue();
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String string) {
            this.key = string;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String string) {
            this.value = string;
        }
    }
}

