/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.jcr;

import com.xebialabs.deployit.DeployitConfiguration;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.RuntimeRepositoryException;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.authentication.AuthenticationFailureException;
import java.io.IOException;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class JcrTemplate {
    private final Repository repository;
    private static final ThreadLocal<Session> SESSION_STORE = new ThreadLocal();
    private static final Logger logger = LoggerFactory.getLogger(JcrTemplate.class);

    @Autowired
    public JcrTemplate(Repository repository) {
        this.repository = repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final <T> T execute(JcrCallback<T> jcrCallback) throws RuntimeIOException, RuntimeRepositoryException {
        Session session = SESSION_STORE.get();
        boolean bl = false;
        if (session == null) {
            logger.debug("Did not find an existing session, creating a session for one JCR request.");
            bl = true;
        } else if (!session.isLive()) {
            logger.debug("Existing session is no longer live, creating a session for one JCR request.");
            bl = true;
        }
        if (bl) {
            try {
                SimpleCredentials simpleCredentials = new SimpleCredentials("admin", DeployitConfiguration.getInstance().getAdminPassword().toCharArray());
                session = this.repository.login((Credentials)simpleCredentials);
                try {
                    T t = jcrCallback.doInJcr(session);
                    return t;
                }
                finally {
                    session.logout();
                }
            }
            catch (AccessDeniedException accessDeniedException) {
                throw PermissionDeniedException.withMessage("Failed to complete your request.", (Exception)((Object)accessDeniedException));
            }
            catch (LoginException loginException) {
                throw new AuthenticationFailureException(loginException, "Incorrect credentials for user %s, did you forget to update the password in the deployit configuration file?", "admin");
            }
            catch (RepositoryException repositoryException) {
                throw new RuntimeRepositoryException(repositoryException.toString(), repositoryException);
            }
            catch (IOException iOException) {
                throw new RuntimeIOException(iOException);
            }
        }
        try {
            return jcrCallback.doInJcr(session);
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(iOException);
        }
        catch (RepositoryException repositoryException) {
            throw new RuntimeRepositoryException(repositoryException.toString(), repositoryException);
        }
    }

    public void login() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (!authentication.isAuthenticated()) {
            logger.error("Didn't get an authenticated request!", (Object)authentication);
            throw new AuthenticationFailureException("User was not yet logged in...");
        }
        logger.debug("Logged in: {}", (Object)authentication.getName());
        SimpleCredentials simpleCredentials = new SimpleCredentials("admin", DeployitConfiguration.getInstance().getAdminPassword().toCharArray());
        try {
            Session session = this.repository.login((Credentials)simpleCredentials);
            SESSION_STORE.set(session);
        }
        catch (AccessDeniedException accessDeniedException) {
            throw PermissionDeniedException.withMessage("Failed to complete your request.", (Exception)((Object)accessDeniedException));
        }
        catch (LoginException loginException) {
            throw new AuthenticationFailureException(loginException, "Couldn't login to the repository", new Object[]{loginException});
        }
        catch (RepositoryException repositoryException) {
            throw new RuntimeRepositoryException(repositoryException.toString(), repositoryException);
        }
    }

    public boolean isLoggedIn() {
        return SESSION_STORE.get() != null && SESSION_STORE.get().isLive();
    }

    public void logout() {
        if (SESSION_STORE.get() != null) {
            SESSION_STORE.get().logout();
            SESSION_STORE.remove();
        } else {
            logger.warn("Superfluous logout call found.", (Throwable)new RuntimeException());
        }
    }
}

