/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.io.Imploder;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.FolderArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.util.PasswordObfuscator;
import com.xebialabs.overthere.OverthereFile;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.value.ReferenceValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NodeWriter {
    private final Session session;
    private final ConfigurationItem item;
    private final Node node;
    private boolean basicsWritten = false;
    private static final Logger logger = LoggerFactory.getLogger(NodeWriter.class);

    NodeWriter(Session session, ConfigurationItem configurationItem, Node node) {
        this.session = session;
        this.item = configurationItem;
        this.node = node;
    }

    void writeBasics() throws RepositoryException {
        this.copyConfigurationItemTypeName();
        this.basicsWritten = true;
    }

    void write() throws RepositoryException {
        if (!this.basicsWritten) {
            this.writeBasics();
        }
        this.copyData();
        this.copyValuesIntoNode();
        this.copyMetadata();
    }

    private void copyConfigurationItemTypeName() throws RepositoryException {
        this.node.setProperty("$configuration.item.type", this.item.getType().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyData() throws RepositoryException {
        OverthereFile overthereFile;
        if (this.item instanceof SourceArtifact && (overthereFile = ((Artifact)this.item).getFile()) != null) {
            InputStream inputStream;
            Object object;
            this.node.setProperty("$filename", overthereFile.getName());
            if (this.item instanceof FolderArtifact && overthereFile.isDirectory()) {
                try {
                    object = Imploder.implode(overthereFile);
                    inputStream = new ByteArrayInputStream((byte[])object);
                }
                catch (IOException iOException) {
                    throw new RuntimeIOException("Could not zip up the data in file " + overthereFile);
                }
            } else {
                inputStream = overthereFile.getInputStream();
            }
            try {
                object = this.session.getValueFactory().createBinary(inputStream);
                this.node.setProperty("$data", (Binary)object);
            }
            finally {
                Closeables.closeQuietly((Closeable)inputStream);
            }
        }
    }

    private void copyValuesIntoNode() throws RepositoryException {
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)this.item.getType());
        Collection collection = Collections2.filter((Collection)descriptor.getPropertyDescriptors(), (Predicate)new Predicate<PropertyDescriptor>(){

            public boolean apply(PropertyDescriptor propertyDescriptor) {
                return !propertyDescriptor.isTransient();
            }
        });
        block9: for (PropertyDescriptor propertyDescriptor : collection) {
            if (propertyDescriptor.get(this.item) == null) {
                this.removePropertyFromNode(propertyDescriptor);
                continue;
            }
            logger.trace("Writing property [{}] with value [{}]", (Object)propertyDescriptor.getFqn(), propertyDescriptor.isPassword() ? "********" : propertyDescriptor.get(this.item));
            switch (propertyDescriptor.getKind()) {
                case BOOLEAN: 
                case INTEGER: 
                case STRING: 
                case ENUM: {
                    this.copyPrimitivePropertyIntoNode(propertyDescriptor);
                    continue block9;
                }
                case SET_OF_STRING: {
                    this.copyCollectionOfStringsPropertyIntoNode(propertyDescriptor);
                    continue block9;
                }
                case SET_OF_CI: {
                    this.copyCollectionOfConfigurationItemsPropertyIntoNode(propertyDescriptor);
                    continue block9;
                }
                case LIST_OF_STRING: {
                    this.copyCollectionOfStringsPropertyIntoNode(propertyDescriptor);
                    continue block9;
                }
                case LIST_OF_CI: {
                    this.copyCollectionOfConfigurationItemsPropertyIntoNode(propertyDescriptor);
                    continue block9;
                }
                case CI: {
                    this.copyConfigurationItemPropertyIntoNode(propertyDescriptor);
                    continue block9;
                }
                case MAP_STRING_STRING: {
                    this.copyMapPropertyIntoNode(propertyDescriptor);
                    continue block9;
                }
            }
            throw new IllegalArgumentException("Cannot convert property " + propertyDescriptor.getName() + " because it is of unsupported kind " + propertyDescriptor.getKind());
        }
    }

    private void copyMapPropertyIntoNode(PropertyDescriptor propertyDescriptor) throws RepositoryException {
        Map map = (Map)propertyDescriptor.get(this.item);
        ArrayList arrayList = Lists.newArrayList();
        for (String string : map.keySet()) {
            Value value = this.session.getValueFactory().createValue(string + "=" + (String)map.get(string));
            arrayList.add(value);
        }
        Value[] valueArray = arrayList.toArray(new Value[arrayList.size()]);
        this.node.setProperty(propertyDescriptor.getName(), valueArray);
    }

    private void copyMetadata() throws RepositoryException {
        this.node.setProperty("$lastModified", Calendar.getInstance());
    }

    private void removePropertyFromNode(PropertyDescriptor propertyDescriptor) throws RepositoryException {
        try {
            this.node.getProperty(propertyDescriptor.getName()).remove();
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    private void copyPrimitivePropertyIntoNode(PropertyDescriptor propertyDescriptor) throws RepositoryException {
        String string = propertyDescriptor.get(this.item).toString();
        if (propertyDescriptor.getKind() == PropertyKind.STRING && propertyDescriptor.isPassword()) {
            string = PasswordObfuscator.ensureEncrypted(string);
        }
        this.node.setProperty(propertyDescriptor.getName(), string);
    }

    private void copyCollectionOfStringsPropertyIntoNode(PropertyDescriptor propertyDescriptor) throws RepositoryException {
        ValueFactory valueFactory = this.session.getValueFactory();
        Collection<?> collection = this.convertObjectValueToCollection(propertyDescriptor, propertyDescriptor.get(this.item));
        ArrayList arrayList = Lists.newArrayList();
        for (Object obj : collection) {
            if (!(obj instanceof String)) {
                throw new IllegalArgumentException("Element in property " + propertyDescriptor.getName() + " of repository entity " + this.item.getId() + " is not a String: " + obj);
            }
            String string = (String)obj;
            arrayList.add(valueFactory.createValue(string));
        }
        Value[] valueArray = arrayList.toArray(new Value[arrayList.size()]);
        this.node.setProperty(propertyDescriptor.getName(), valueArray);
    }

    private void copyConfigurationItemPropertyIntoNode(PropertyDescriptor propertyDescriptor) throws RepositoryException {
        if (propertyDescriptor.isAsContainment()) {
            return;
        }
        String string = ((ConfigurationItem)propertyDescriptor.get(this.item)).getId();
        Node node = this.session.getNode(JcrPathHelper.getAbsolutePathFromId(string));
        this.node.setProperty(propertyDescriptor.getName(), node);
    }

    private void copyCollectionOfConfigurationItemsPropertyIntoNode(PropertyDescriptor propertyDescriptor) throws RepositoryException {
        if (propertyDescriptor.isAsContainment()) {
            return;
        }
        Collection<?> collection = this.convertObjectValueToCollection(propertyDescriptor, propertyDescriptor.get(this.item));
        ArrayList arrayList = Lists.newArrayList();
        for (Object obj : collection) {
            if (!(obj instanceof ConfigurationItem)) {
                throw new IllegalArgumentException("Element in property " + propertyDescriptor.getName() + " of repository entity " + this.item.getId() + " is not a ConfigurationItem: " + obj);
            }
            String string = ((ConfigurationItem)obj).getId();
            Node node = this.session.getNode(JcrPathHelper.getAbsolutePathFromId(string));
            arrayList.add(new ReferenceValue(node));
        }
        Value[] valueArray = arrayList.toArray(new Value[arrayList.size()]);
        this.node.setProperty(propertyDescriptor.getName(), valueArray);
    }

    private Collection<?> convertObjectValueToCollection(PropertyDescriptor propertyDescriptor, Object object) {
        if (!(object instanceof Collection)) {
            throw new IllegalArgumentException("Property " + propertyDescriptor.getName() + " of repository entity " + this.item.getId() + " is not a Collection: " + object);
        }
        return (Collection)object;
    }
}

