/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer.source;

import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.io.OutputSupplier;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import com.xebialabs.deployit.service.importer.source.FileSource;
import com.xebialabs.deployit.util.GuavaFiles;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlSource
implements ImportSource {
    private final URL location;
    private FileSource downloaded;
    private final File tempDir;
    private static final Logger logger = LoggerFactory.getLogger(UrlSource.class);

    public UrlSource(URL uRL) {
        this.location = uRL;
        this.tempDir = Files.createTempDir();
    }

    private void download() {
        try {
            logger.debug("Preparing to download package from {}", (Object)this.location);
            HttpClient httpClient = new HttpClient();
            URI uRI = this.location.toURI();
            GetMethod getMethod = new GetMethod(uRI.toString());
            int n = httpClient.executeMethod((HttpMethod)getMethod);
            if (n != 200) {
                throw new RuntimeIOException("Failed to download package,status=" + n + ", from url " + this.location);
            }
            this.save(uRI, getMethod.getResponseBodyAsStream());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Invalid URL", uRISyntaxException);
        }
        catch (HttpException httpException) {
            throw new RuntimeIOException(httpException);
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(URI uRI, InputStream inputStream) throws IOException {
        try {
            String string = uRI.getPath();
            String string2 = new File(string).getName();
            File file = new File(this.tempDir, string2);
            ByteStreams.copy((InputStream)inputStream, (OutputSupplier)Files.newOutputStreamSupplier((File)file));
            this.downloaded = new FileSource(file, true);
        }
        finally {
            Closeables.closeQuietly((Closeable)inputStream);
        }
    }

    public File getFile() {
        if (this.downloaded == null) {
            this.download();
        }
        logger.debug("Successfully downloaded file {}", (Object)this.downloaded.getFile().getName());
        return this.downloaded.getFile();
    }

    public void cleanUp() {
        if (this.downloaded != null) {
            this.downloaded.cleanUp();
        }
        GuavaFiles.deleteQuietly(this.tempDir);
    }

    public String toString() {
        return "UrlSource[" + this.location + "]";
    }
}

