/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.cli.CliObject;
import com.xebialabs.deployit.cli.api.DocumentedObject;
import com.xebialabs.deployit.cli.api.Proxies;
import com.xebialabs.deployit.cli.api.internal.DescriptorHelper;
import com.xebialabs.deployit.cli.help.ClassHelp;
import com.xebialabs.deployit.cli.help.ExportHelp;
import com.xebialabs.deployit.cli.help.MethodHelp;
import com.xebialabs.deployit.cli.help.ParameterHelp;
import com.xebialabs.deployit.cli.rest.ResponseExtractor;
import com.xebialabs.deployit.core.api.dto.ArtifactAndData;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDtos;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemIds;
import com.xebialabs.deployit.core.api.dto.FullTaskInfos;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import com.xebialabs.deployit.core.api.resteasy.Date;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CliObject(name="repository")
@ClassHelp(description="Gateway to doing CRUD operations on all types of CIs")
public class RepositoryClient
extends DocumentedObject {
    public static final Function<ConfigurationItemId, String> ciIdToString = new Function<ConfigurationItemId, String>(){

        public String apply(ConfigurationItemId configurationItemId) {
            return configurationItemId.getId();
        }
    };
    private final Proxies proxies;
    private final DescriptorHelper descriptors;
    private final String parseDateFormat = "MM/dd/yyyy";
    private final String resultDateFormat = "dd MMM yyyy HH:mm z";
    private static final Logger logger = LoggerFactory.getLogger(RepositoryClient.class);

    public RepositoryClient() {
        this.proxies = null;
        this.descriptors = null;
    }

    public RepositoryClient(Proxies proxies) {
        this.proxies = proxies;
        this.descriptors = DescriptorHelper.getInstance(proxies);
    }

    @MethodHelp(description="Create a new CI in the repository", parameters={@ParameterHelp(name="ci", description="The CI (ConfigurationItem) that should be created in the repository")})
    public RepositoryObject create(ConfigurationItemDto configurationItemDto) {
        Preconditions.checkArgument((configurationItemDto.getId() != null ? 1 : 0) != 0, (Object)"The repository object should have a set id.");
        Response response = this.proxies.getRepository().create(configurationItemDto.getId(), configurationItemDto);
        return this.checkForValidations(response);
    }

    @MethodHelp(description="Create a new artifact CI in the repository", parameters={@ParameterHelp(name="artifact", description="The Artifact that should be created in the repository")})
    public RepositoryObject create(ArtifactAndData artifactAndData) {
        Preconditions.checkArgument((artifactAndData.getArtifact().getId() != null ? 1 : 0) != 0, (Object)"The artifact should have a set id.");
        Response response = this.proxies.getRepository().create(artifactAndData.getArtifact().getId(), artifactAndData);
        return this.checkForValidations(response);
    }

    @MethodHelp(description="Create all new CIs in the repository, commonly used after a discovery", parameters={@ParameterHelp(name="cis", description="The CIs (ConfigurationItems) that should be created in the repository")})
    public ConfigurationItemDtos create(ConfigurationItemDtos configurationItemDtos) {
        Response response = this.proxies.getRepository().createMultiple(configurationItemDtos);
        return this.checkAllForValidations(response);
    }

    @MethodHelp(description="Create all new CIs in the repository, commonly used after a discovery", parameters={@ParameterHelp(name="cis", description="The CIs (ConfigurationItems) that should be created in the repository")})
    public ConfigurationItemDtos create(List<ConfigurationItemDto> list) {
        Response response = this.proxies.getRepository().createMultiple(new ConfigurationItemDtos(list));
        return this.checkAllForValidations(response);
    }

    private ConfigurationItemDtos checkAllForValidations(Response response) {
        ResponseExtractor responseExtractor = new ResponseExtractor(response);
        ConfigurationItemDtos configurationItemDtos = (ConfigurationItemDtos)responseExtractor.getEntity();
        if (!responseExtractor.isValidResponse()) {
            for (ConfigurationItemDto configurationItemDto : configurationItemDtos.getObjects()) {
                if (configurationItemDto.getValidations().isEmpty()) continue;
                logger.error("Configuration item contained validation errors: {}", (Object)configurationItemDto.getValidations());
            }
        }
        return configurationItemDtos;
    }

    @MethodHelp(description="Read a CI form the repository", parameters={@ParameterHelp(name="id", description="The id of the CI to read")})
    public RepositoryObject read(String string) {
        return (RepositoryObject)new ResponseExtractor(this.proxies.getRepository().read(string)).getEntity();
    }

    @MethodHelp(description="Update an existing CI in the repository", parameters={@ParameterHelp(name="ci", description="The updated CI (ConfigurationItem) that should be stored in the repository")})
    public RepositoryObject update(ConfigurationItemDto configurationItemDto) {
        Preconditions.checkArgument((configurationItemDto.getId() != null ? 1 : 0) != 0, (Object)"The repository object should have a set id.");
        Response response = this.proxies.getRepository().update(configurationItemDto.getId(), configurationItemDto);
        return this.checkForValidations(response);
    }

    @MethodHelp(description="Update an existing artifact in the repository", parameters={@ParameterHelp(name="artifact", description="The updated artifact CI that should be stored in the repository")})
    public RepositoryObject update(ArtifactAndData artifactAndData) {
        Preconditions.checkArgument((artifactAndData.getArtifact().getId() != null ? 1 : 0) != 0, (Object)"The repository object should have a set id.");
        Response response = this.proxies.getRepository().update(artifactAndData.getArtifact().getId(), artifactAndData);
        return this.checkForValidations(response);
    }

    @MethodHelp(description="Move a CI from one location to another", parameters={@ParameterHelp(name="ci", description="The CI that is to be moved"), @ParameterHelp(name="newId", description="The new id of the CI")}, returns="The CI with the new id")
    public RepositoryObject move(ConfigurationItemDto configurationItemDto, String string) {
        return this.move(configurationItemDto.getId(), string);
    }

    @MethodHelp(description="Move a CI from one location to another", parameters={@ParameterHelp(name="id", description="The id of the CI that is to be moved"), @ParameterHelp(name="newId", description="The new id of the CI")}, returns="The CI with the new id")
    public RepositoryObject move(String string, String string2) {
        return (RepositoryObject)new ResponseExtractor(this.proxies.getRepository().move(string, string2)).getEntity();
    }

    @MethodHelp(description="Rename a CI", parameters={@ParameterHelp(name="ci", description="The CI to rename"), @ParameterHelp(name="newName", description="The new name (last part of the id)")}, returns="The CI with the updated name")
    public RepositoryObject rename(ConfigurationItemDto configurationItemDto, String string) {
        return this.rename(configurationItemDto.getId(), string);
    }

    @MethodHelp(description="Rename a CI", parameters={@ParameterHelp(name="id", description="The id of the CI to rename"), @ParameterHelp(name="newName", description="The new name (last part of the id)")}, returns="The CI with the updated name")
    public RepositoryObject rename(String string, String string2) {
        return (RepositoryObject)new ResponseExtractor(this.proxies.getRepository().rename(string, string2)).getEntity();
    }

    @MethodHelp(description="Delete a CI with a specific id from the repository", parameters={@ParameterHelp(name="id", description="The id of the CI")})
    public void delete(String string) {
        new ResponseExtractor(this.proxies.getRepository().delete(string));
    }

    @MethodHelp(description="Search for CIs of a specific type in the repository", parameters={@ParameterHelp(name="ciType", description="")}, returns="The ids of the configuration items that fit the query.")
    public List<String> search(String string) {
        String string2 = null;
        if (string != null && (string2 = this.descriptors.getRegisteredType(string)) == null) {
            System.err.println("Configuration item type [null] not known.");
            return null;
        }
        ConfigurationItemIds configurationItemIds = (ConfigurationItemIds)new ResponseExtractor(this.proxies.getQuery().list(string2, Boolean.FALSE.booleanValue(), 0L, -1L, null, null, null)).getEntity();
        return Lists.newArrayList((Iterable)Lists.transform((List)configurationItemIds.getConfigurationItemIds(), ciIdToString));
    }

    @MethodHelp(description="Search for CIs of a specific type in the repository which are located under the specified parent node.", parameters={@ParameterHelp(name="ciType", description="The type of configuration item to look for (eg. udm.DeployedApplication)"), @ParameterHelp(name="parent", description="The id of the parent node to search under (eg. Environments/env1)")}, returns="The ids of the configuration items that fit the query.")
    public List<String> search(String string, String string2) {
        String string3 = this.descriptors.getRegisteredType(string);
        ConfigurationItemIds configurationItemIds = (ConfigurationItemIds)new ResponseExtractor(this.proxies.getQuery().list(string3, Boolean.FALSE.booleanValue(), 0L, -1L, null, string2, null)).getEntity();
        return Lists.newArrayList((Iterable)Lists.transform((List)configurationItemIds.getConfigurationItemIds(), ciIdToString));
    }

    @MethodHelp(description="Search for CIs of a specific type in the repository were created before the given date.", parameters={@ParameterHelp(name="ciType", description="The type of configuration item to look for (eg. udm.DeployedApplication)"), @ParameterHelp(name="before", description="a java.util.Calendar which specifies a moment in time before which the CI has to be created")}, returns="The ids of the configuration items that fit the query.")
    public List<String> search(String string, Calendar calendar) {
        ConfigurationItemIds configurationItemIds = (ConfigurationItemIds)new ResponseExtractor(this.proxies.getQuery().search(string, new Date(calendar))).getEntity();
        return Lists.newArrayList((Iterable)Lists.transform((List)configurationItemIds.getConfigurationItemIds(), ciIdToString));
    }

    @MethodHelp(description="Read multiple objects from the repostory in one go.", parameters={@ParameterHelp(name="ids", description="The ids of the objects to read")})
    public List<ConfigurationItemDto> read(String ... stringArray) {
        ConfigurationItemIds configurationItemIds = new ConfigurationItemIds();
        configurationItemIds.setConfigurationItemIds(Lists.transform(Arrays.asList(stringArray), (Function)new Function<String, ConfigurationItemId>(){

            public ConfigurationItemId apply(String string) {
                return new ConfigurationItemId(string, null);
            }
        }));
        ConfigurationItemDtos configurationItemDtos = (ConfigurationItemDtos)new ResponseExtractor(this.proxies.getQuery().readMultiple(configurationItemIds)).getEntity();
        return configurationItemDtos.getObjects();
    }

    @MethodHelp(description="Get all task information, including steps, from the repository's archive.", returns="This object contains all archived tasks with their enclosed steps")
    public FullTaskInfos getArchivedTasks() {
        return (FullTaskInfos)new ResponseExtractor(this.proxies.getTaskExport().getFullArchivedTasks()).getEntity();
    }

    @MethodHelp(description="Get all task information, including steps, from the repository's archive in the specified date range.", parameters={@ParameterHelp(name="beginDate", description="Begin date from which to return tasks in 'MM/dd/yyyy' format"), @ParameterHelp(name="endDate", description="End date from which to return tasks in 'MM/dd/yyyy' format")}, returns="This object contains all archived tasks with their enclosed steps")
    public FullTaskInfos getArchivedTasks(String string, String string2) {
        return (FullTaskInfos)new ResponseExtractor(this.proxies.getTaskExport().getFullArchivedTasksInDateRange(new Date(ExportHelp.parseDateFormat(string, "MM/dd/yyyy", "dd MMM yyyy HH:mm z")), new Date(ExportHelp.parseDateFormat(string2, "MM/dd/yyyy", "dd MMM yyyy HH:mm z")))).getEntity();
    }

    @MethodHelp(description="Export all task information, including steps, from the repository's archive to a local XML file", parameters={@ParameterHelp(name="filePath", description="Fully qualified pathname, including the file name, as to where to store the file to. Example: '/tmp/exportedTasks.xml'")})
    public void exportArchivedTasks(String string) throws IOException {
        this.getResourceToWrite(string, "/deployit/export/tasks");
    }

    @MethodHelp(description="Export all task information, including steps, from the repository's archive in the specified date range to a local XML file", parameters={@ParameterHelp(name="filePath", description="Fully qualified pathname, including the file name, as to where to store the file to. Example: '/tmp/exportedTasks.xml'"), @ParameterHelp(name="beginDate", description="Begin date from which to return tasks in 'MM/dd/yyyy' format"), @ParameterHelp(name="endDate", description="End date from which to return tasks in 'MM/dd/yyyy' format")})
    public void exportArchivedTasks(String string, String string2, String string3) throws IOException {
        this.getResourceToWrite(string, String.format("/deployit/export/taskrange?begin=%s&end=%s", ExportHelp.encodeURIDateFormat(ExportHelp.parseDateFormat(string2, "MM/dd/yyyy", "dd MMM yyyy HH:mm z"), "UTF-8"), ExportHelp.encodeURIDateFormat(ExportHelp.parseDateFormat(string3, "MM/dd/yyyy", "dd MMM yyyy HH:mm z"), "UTF-8")));
    }

    @MethodHelp(description="Check for existence of an id, does not guarantee read access to said configuration item.", parameters={@ParameterHelp(name="id", description="The id of the configuration item")}, returns="true if there is a configuration item with that id.")
    public boolean exists(String string) {
        ResponseExtractor responseExtractor = new ResponseExtractor(this.proxies.getRepository().exists(string));
        return responseExtractor.isValidResponse();
    }

    private RepositoryObject checkForValidations(Response response) {
        ResponseExtractor responseExtractor = new ResponseExtractor(response);
        RepositoryObject repositoryObject = (RepositoryObject)responseExtractor.getEntity();
        if (!responseExtractor.isValidResponse() && !repositoryObject.getValidations().isEmpty()) {
            logger.error("Configuration item contained validation errors: {}", (Object)repositoryObject.getValidations());
        }
        return repositoryObject;
    }

    private final void getResourceToWrite(String string, String string2) throws IOException {
        if (ExportHelp.writeResourceToLocalFile(this.proxies.getAuthentication(), string, string2) > 0L) {
            System.out.println(String.format("Written archived tasks to %s", string));
        } else {
            System.out.println("File was created but no bytes were written to the file.\n");
            System.out.println("Maybe the requested resource was not available or zero size!?");
        }
    }
}

