/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.help;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.cli.CliObject;
import com.xebialabs.deployit.cli.help.ClassHelp;
import com.xebialabs.deployit.cli.help.MethodHelp;
import com.xebialabs.deployit.cli.help.ParameterHelp;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;

public class HelpScanner {
    private static final AtomicReference<Set<Class<?>>> discoveredCliObjects = new AtomicReference();

    public static void printHelp(Set<Class<?>> set) {
        discoveredCliObjects.set(set);
        HelpScanner.printHelp();
    }

    public static void printHelp() {
        TreeSet treeSet = Sets.newTreeSet((Comparator)new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> clazz, Class<?> clazz2) {
                return clazz.getSimpleName().compareTo(clazz2.getSimpleName());
            }
        });
        treeSet.addAll((Collection)discoveredCliObjects.get());
        System.out.println("Deployit Objects available on the CLI:\n");
        for (Class clazz : treeSet) {
            ClassHelp classHelp = clazz.getAnnotation(ClassHelp.class);
            CliObject cliObject = clazz.getAnnotation(CliObject.class);
            if (classHelp == null) continue;
            System.out.printf("* %s: %s\n", cliObject.name(), classHelp.description());
        }
        System.out.println("\nTo know more about a specific object, type <objectname>.help()");
        System.out.println("To get to know more about a specific method of an object, type <objectname>.help(\"<methodname>\")\n");
    }

    public static void printHelp(Class<?> clazz) {
        ClassHelp classHelp = clazz.getAnnotation(ClassHelp.class);
        CliObject cliObject = clazz.getAnnotation(CliObject.class);
        if (classHelp != null) {
            String string = cliObject.name();
            System.out.printf("%s: %s\n\n", string, classHelp.description());
            HelpScanner.printMethods(string, clazz);
            System.out.println();
        } else {
            System.out.println("Not found help for " + clazz);
        }
    }

    public static void printHelp(Class<?> clazz, String string) {
        ClassHelp classHelp = clazz.getAnnotation(ClassHelp.class);
        CliObject cliObject = clazz.getAnnotation(CliObject.class);
        if (classHelp != null) {
            String string2 = cliObject.name();
            for (Method method : clazz.getMethods()) {
                if (!method.getName().equals(string)) continue;
                HelpScanner.printMethod(string2, method);
                HelpScanner.printMethodDetails(method);
                System.out.println();
            }
        }
    }

    private static void printMethodDetails(Method method) {
        MethodHelp methodHelp = method.getAnnotation(MethodHelp.class);
        if (methodHelp != null) {
            System.out.println();
            System.out.printf("Description:\n%s\n\n", methodHelp.description());
            System.out.print("Parameters:\n");
            if (methodHelp.parameters().length != 0) {
                for (ParameterHelp parameterHelp : methodHelp.parameters()) {
                    System.out.printf("  %s: %s\n", parameterHelp.name(), parameterHelp.description());
                }
            } else {
                System.out.print("None\n");
            }
            System.out.println();
            System.out.printf("Returns:\n%s - %s\n", method.getReturnType().getSimpleName(), methodHelp.returns());
        }
    }

    private static void printMethods(String string, Class<?> clazz) {
        ArrayList arrayList = Lists.newArrayList((Object[])clazz.getDeclaredMethods());
        Collections.sort(arrayList, new Comparator<Method>(){

            @Override
            public int compare(Method method, Method method2) {
                if (method.getName().equals(method2.getName())) {
                    return 0;
                }
                return method.getName().compareTo(method2.getName());
            }
        });
        System.out.println("The methods available are:");
        for (Method method : arrayList) {
            HelpScanner.printMethod(string, method);
        }
    }

    private static void printMethod(String string, Method method) {
        MethodHelp methodHelp = method.getAnnotation(MethodHelp.class);
        if (methodHelp != null) {
            ParameterHelp[] parameterHelpArray;
            String string2 = method.getName();
            StringBuilder stringBuilder = new StringBuilder();
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray.length != (parameterHelpArray = methodHelp.parameters()).length) {
                throw new IllegalArgumentException("Not all parameters are documented!");
            }
            for (int i = 0; i < classArray.length; ++i) {
                stringBuilder.append(classArray[i].getSimpleName());
                stringBuilder.append(" ").append(parameterHelpArray[i].name());
                if (i >= classArray.length - 1) continue;
                stringBuilder.append(", ");
            }
            System.out.printf("* %s.%s(%s) : %s\n", string, string2, stringBuilder, method.getReturnType().getSimpleName());
        }
    }
}

