/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.reflect;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.inspection.InspectionProperty;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.GlobalContext;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.ReflectionUtils;
import com.xebialabs.deployit.plugin.api.reflect.SyntheticHelper;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.reflect.ValidationRuleConverter;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.utils.Strings;
import com.xebialabs.deployit.plugin.api.validation.ReferenceCollectionTypeValidator;
import com.xebialabs.deployit.plugin.api.validation.RequiredValidator;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.deployit.plugin.api.validation.Validator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class PropertyDescriptor {
    private Descriptor declaringDescriptor;
    private String name;
    private Field field;
    private boolean asContainment;
    private String category;
    private String description;
    private String label;
    private boolean password;
    private boolean required;
    private Property.Size size;
    private PropertyKind kind;
    private List<String> enumValues;
    private Class<?> enumClass;
    private Type referencedType;
    private boolean hidden;
    private boolean inspectionProperty;
    private boolean requiredForInspection;
    private boolean isTransient;
    private Set<Validator<?>> validationRules = Sets.newHashSet();
    private static final Logger logger = LoggerFactory.getLogger(PropertyDescriptor.class);

    private PropertyDescriptor(Field field) {
        this.name = field.getName();
        this.field = field;
        field.setAccessible(true);
    }

    private PropertyDescriptor(String string) {
        this.name = string;
        this.field = null;
    }

    PropertyDescriptor(PropertyDescriptor propertyDescriptor, Descriptor descriptor) {
        this.declaringDescriptor = descriptor;
        this.name = propertyDescriptor.name;
        this.field = propertyDescriptor.field;
        this.asContainment = propertyDescriptor.asContainment;
        this.category = propertyDescriptor.category;
        this.description = propertyDescriptor.description;
        this.label = propertyDescriptor.label;
        this.password = propertyDescriptor.password;
        this.required = propertyDescriptor.required;
        this.size = propertyDescriptor.size;
        this.kind = propertyDescriptor.kind;
        this.enumValues = propertyDescriptor.enumValues;
        this.enumClass = propertyDescriptor.enumClass;
        this.referencedType = propertyDescriptor.referencedType;
        this.hidden = propertyDescriptor.hidden;
        this.inspectionProperty = propertyDescriptor.inspectionProperty;
        this.requiredForInspection = propertyDescriptor.requiredForInspection;
        this.validationRules = Sets.newHashSet(propertyDescriptor.validationRules);
        this.isTransient = propertyDescriptor.isTransient();
        GlobalContext.register(this, propertyDescriptor);
    }

    static PropertyDescriptor from(Descriptor descriptor, Field field) {
        Property property = field.getAnnotation(Property.class);
        PropertyDescriptor propertyDescriptor = new PropertyDescriptor(field);
        propertyDescriptor.declaringDescriptor = descriptor;
        propertyDescriptor.initMetadata(property);
        propertyDescriptor.initType(property);
        PropertyDescriptor.initInspectionMetadata(field, propertyDescriptor);
        PropertyDescriptor.initValidationMetadata(field, propertyDescriptor);
        PropertyDescriptor.verify(propertyDescriptor);
        return propertyDescriptor;
    }

    private static void initValidationMetadata(Field field, PropertyDescriptor propertyDescriptor) {
        propertyDescriptor.addDefaultValidationRules();
        for (Annotation annotation : field.getAnnotations()) {
            if (!ValidationRuleConverter.isRule(annotation)) continue;
            propertyDescriptor.validationRules.add(ValidationRuleConverter.makeRule(annotation));
        }
    }

    static PropertyDescriptor from(Descriptor descriptor, Element element) {
        String string = SyntheticHelper.getRequiredStringAttribute(element, "name");
        PropertyDescriptor propertyDescriptor = new PropertyDescriptor(string);
        propertyDescriptor.declaringDescriptor = descriptor;
        propertyDescriptor.initSynthetic(element);
        PropertyDescriptor.verify(propertyDescriptor);
        return propertyDescriptor;
    }

    private static void verify(PropertyDescriptor propertyDescriptor) {
        PropertyDescriptor.verifyName(propertyDescriptor, "name");
        PropertyDescriptor.verifyName(propertyDescriptor, "id");
        PropertyDescriptor.verifyName(propertyDescriptor, "type");
        if (propertyDescriptor.hidden) {
            Preconditions.checkState((boolean)propertyDescriptor.isTransient, (String)"Hidden property %s should be transient", (Object[])new Object[]{propertyDescriptor});
        }
        if (propertyDescriptor.kind == PropertyKind.BOOLEAN && propertyDescriptor.required) {
            logger.warn("Boolean property {} should not be required.", (Object)propertyDescriptor);
            propertyDescriptor.required = false;
        }
    }

    private static void verifyName(PropertyDescriptor propertyDescriptor, String string) {
        Preconditions.checkArgument((!propertyDescriptor.name.equals(string) ? 1 : 0) != 0, (String)"Cannot define a property named '%s' on %s", (Object[])new Object[]{string, propertyDescriptor.declaringDescriptor});
    }

    private static void initInspectionMetadata(Field field, PropertyDescriptor propertyDescriptor) {
        if (field.isAnnotationPresent(InspectionProperty.class)) {
            propertyDescriptor.inspectionProperty = true;
            propertyDescriptor.requiredForInspection = field.getAnnotation(InspectionProperty.class).required();
        }
    }

    private void initMetadata(Property property) {
        this.category = property.category();
        this.label = Strings.isBlank(property.label()) ? PropertyDescriptor.deCamelize(this.name) : property.label();
        this.description = Strings.isBlank(property.description()) ? this.label : property.description();
        this.password = property.password();
        this.required = property.required();
        this.size = property.size();
        this.hidden = property.hidden();
        this.isTransient = this.hidden || property.isTransient();
    }

    private void initType(Property property) {
        Class<?> clazz = this.field.getType();
        if (clazz == Boolean.TYPE) {
            this.kind = PropertyKind.BOOLEAN;
        } else if (clazz == Integer.TYPE) {
            this.kind = PropertyKind.INTEGER;
        } else if (clazz == String.class) {
            this.kind = PropertyKind.STRING;
        } else if (clazz.isEnum()) {
            this.kind = PropertyKind.ENUM;
            this.initEnumValues(this.field.getType());
        } else if (ConfigurationItem.class.isAssignableFrom(clazz)) {
            this.kind = PropertyKind.CI;
            this.referencedType = Type.valueOf(clazz);
            this.asContainment = property.asContainment();
        } else if (Set.class.isAssignableFrom(clazz)) {
            this.initSetType(property);
        } else if (Map.class.isAssignableFrom(clazz)) {
            this.initMapType(property);
        } else if (List.class.isAssignableFrom(clazz)) {
            this.initListType(property);
        } else {
            throw new IllegalArgumentException(String.format("Type of %s not supported as an @Property field, found on %s.%s", clazz.getName(), this.field.getDeclaringClass().getName(), this.name));
        }
        GlobalContext.register(this, com.google.common.base.Strings.emptyToNull((String)property.defaultValue()));
    }

    private Object convertValue(String string) {
        if (com.google.common.base.Strings.isNullOrEmpty((String)string)) {
            return string;
        }
        switch (this.kind) {
            case BOOLEAN: {
                return Boolean.parseBoolean(string);
            }
            case INTEGER: {
                return Integer.parseInt(string);
            }
            case STRING: {
                return string;
            }
            case ENUM: {
                for (Enum enum_ : (Enum[])this.enumClass.getEnumConstants()) {
                    if (!enum_.name().equalsIgnoreCase(string)) continue;
                    return enum_;
                }
                throw new IllegalArgumentException("Value " + string + " not a member of enum " + this.field.getType());
            }
            case SET_OF_STRING: {
                return Sets.newHashSet(this.splitValue(string));
            }
            case LIST_OF_STRING: {
                return Lists.newArrayList(this.splitValue(string));
            }
            case MAP_STRING_STRING: {
                return this.decodeMap(string);
            }
        }
        throw new IllegalArgumentException("Property " + this.name + " of kind " + (Object)((Object)this.kind) + " cannot be converted from a string value");
    }

    private Iterable<String> splitValue(String string) {
        return Splitter.on((char)',').trimResults().split((CharSequence)string);
    }

    private Map<String, String> decodeMap(String string) {
        HashMap hashMap = Maps.newHashMap();
        for (String string2 : this.splitValue(string)) {
            String[] stringArray = string2.split(":");
            Preconditions.checkArgument((com.google.common.base.Strings.emptyToNull((String)stringArray[0]) != null ? 1 : 0) != 0, (String)"Property %s of kind %s cannot be converted from string value '%s' because of any empty key.", (Object[])new Object[]{this.name, this.kind, string});
            if (stringArray.length == 1) {
                hashMap.put(stringArray[0], "");
                continue;
            }
            hashMap.put(stringArray[0], stringArray[1]);
        }
        return hashMap;
    }

    private void initSetType(Property property) {
        Class<?> clazz = this.getGenericType(Set.class, 1, 0);
        if (clazz == String.class) {
            this.kind = PropertyKind.SET_OF_STRING;
        } else if (ConfigurationItem.class.isAssignableFrom(clazz)) {
            this.kind = PropertyKind.SET_OF_CI;
            this.referencedType = Type.valueOf(clazz);
            this.asContainment = property.asContainment();
        } else {
            throw new IllegalStateException(String.format("Unsupported Set type encountered for [%s]. Only support String and ConfigurationItem", this.name));
        }
    }

    private void initMapType(Property property) {
        Preconditions.checkArgument((this.getGenericType(Map.class, 2, 0) == String.class ? 1 : 0) != 0, (String)"Property %s.%s of type Map should be Map<String, String>", (Object[])new Object[]{this.field.getDeclaringClass().getName(), this.name});
        Preconditions.checkArgument((this.getGenericType(Map.class, 2, 1) == String.class ? 1 : 0) != 0, (String)"Property %s.%s of type Map should be Map<String, String>", (Object[])new Object[]{this.field.getDeclaringClass().getName(), this.name});
        this.kind = PropertyKind.MAP_STRING_STRING;
    }

    private void initListType(Property property) {
        Class<?> clazz = this.getGenericType(List.class, 1, 0);
        if (clazz == String.class) {
            this.kind = PropertyKind.LIST_OF_STRING;
        } else if (ConfigurationItem.class.isAssignableFrom(clazz)) {
            this.kind = PropertyKind.LIST_OF_CI;
            this.referencedType = Type.valueOf(clazz);
            this.asContainment = property.asContainment();
        } else {
            throw new IllegalStateException(String.format("Unsupported List type encountered for [%s]. Only support String and ConfigurationItem", this.name));
        }
    }

    private Class<?> getGenericType(Class<?> clazz, int n, int n2) {
        java.lang.reflect.Type type = this.field.getGenericType();
        Preconditions.checkArgument((boolean)(type instanceof ParameterizedType), (String)"The field %s.%s is a %s but it isn't a generic type (%s)", (Object[])new Object[]{this.field.getDeclaringClass().getName(), this.name, clazz, type});
        Object[] objectArray = ((ParameterizedType)type).getActualTypeArguments();
        Preconditions.checkArgument((objectArray.length == n ? 1 : 0) != 0, (String)"The field %s is a %s.%s but it doesn't have the right generic type (%s)", (Object[])new Object[]{this.field.getDeclaringClass().getName(), this.name, clazz, objectArray});
        Preconditions.checkArgument((boolean)(objectArray[n2] instanceof Class), (String)"The field %s.%s is a %s but it is not a concrete subclass (%s)", (Object[])new Object[]{this.field.getDeclaringClass().getName(), this.name, clazz, Arrays.toString(objectArray)});
        return (Class)objectArray[n2];
    }

    private void initEnumValues(Class<?> clazz) {
        this.enumValues = Lists.newArrayList();
        this.enumClass = clazz;
        for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
            this.enumValues.add(enum_.name());
        }
    }

    void overrideWith(PropertyDescriptor propertyDescriptor) {
        Preconditions.checkArgument((propertyDescriptor.getKind() == this.getKind() ? 1 : 0) != 0, (String)"Type '%s' attempts to overrides property '%s' declared in type '%s', but kind attribute does not match. Derived kind: '%s'. Super kind: '%s'.", (Object[])new Object[]{this.getDeclaringDescriptor().getType(), this.getName(), propertyDescriptor.getDeclaringDescriptor().getType(), this.getKind(), propertyDescriptor.getKind()});
        this.checkOverrideArgument(propertyDescriptor.isAsContainment() == this.isAsContainment(), "asContainment", propertyDescriptor.isAsContainment(), propertyDescriptor);
        this.checkOverrideArgument(propertyDescriptor.getReferencedType() == null && this.getReferencedType() == null || propertyDescriptor.getReferencedType() != null && propertyDescriptor.getReferencedType().equals(this.getReferencedType()), "referenceType", propertyDescriptor.getReferencedType(), propertyDescriptor);
        this.checkOverrideArgument(propertyDescriptor.enumClass == this.enumClass, "enumClass", propertyDescriptor.enumClass, propertyDescriptor);
        this.checkOverrideArgument(propertyDescriptor.isPassword() == this.isPassword(), "password", propertyDescriptor.isPassword(), propertyDescriptor);
        if (propertyDescriptor.isRequired()) {
            this.checkOverrideArgument(this.isRequired(), "required", propertyDescriptor.isRequired(), propertyDescriptor);
        }
        this.field = propertyDescriptor.field;
    }

    private void checkOverrideArgument(boolean bl, String string, Object object, PropertyDescriptor propertyDescriptor) {
        Preconditions.checkArgument((boolean)bl, (String)"Type '%s' attempts to overrides property '%s' declared in type '%s', but '%s' attribute does not match that in the super type. Should be set to %s.", (Object[])new Object[]{this.getDeclaringDescriptor().getType(), this.getName(), propertyDescriptor.getDeclaringDescriptor().getType(), string, object});
    }

    private void initSynthetic(Element element) {
        this.kind = PropertyKind.valueOf(SyntheticHelper.getOptionalStringAttribute(element, "kind", PropertyKind.STRING.name()).toUpperCase());
        this.category = SyntheticHelper.getOptionalStringAttribute(element, "category", "Common");
        this.label = SyntheticHelper.getOptionalStringAttribute(element, "label", PropertyDescriptor.deCamelize(this.name));
        this.description = SyntheticHelper.getOptionalStringAttribute(element, "description", this.label);
        this.required = SyntheticHelper.getOptionalBooleanAttribute(element, "required", true);
        this.password = SyntheticHelper.getOptionalBooleanAttribute(element, "password", false);
        this.asContainment = SyntheticHelper.getOptionalBooleanAttribute(element, "as-containment", false);
        this.size = Property.Size.valueOf(SyntheticHelper.getOptionalStringAttribute(element, "size", Property.Size.MEDIUM.name()).toUpperCase());
        String string = SyntheticHelper.getOptionalStringAttribute(element, "default", null);
        this.hidden = SyntheticHelper.getOptionalBooleanAttribute(element, "hidden", false);
        this.isTransient = this.hidden ? true : SyntheticHelper.getOptionalBooleanAttribute(element, "transient", false);
        if (this.kind == PropertyKind.ENUM) {
            String string2 = SyntheticHelper.getRequiredStringAttribute(element, "enum-class", "for property " + this.name + " of kind " + (Object)((Object)this.kind));
            try {
                this.enumClass = Class.forName(string2);
                if (!this.enumClass.isEnum()) {
                    throw new IllegalArgumentException("enum-class supplied for property " + this.name + " of kind " + (Object)((Object)this.kind) + " is not an enum: " + string2);
                }
                this.initEnumValues(this.enumClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException("Unknown enum-class supplied for property " + this.name + " of kind " + (Object)((Object)this.kind) + ": " + string2, classNotFoundException);
            }
        }
        if (this.kind == PropertyKind.CI || this.kind == PropertyKind.SET_OF_CI || this.kind == PropertyKind.LIST_OF_CI) {
            this.referencedType = Type.valueOf(SyntheticHelper.getRequiredStringAttribute(element, "referenced-type", "for property " + this.name + " of kind " + (Object)((Object)this.kind)));
        }
        this.initSyntheticValidationRules(element);
        this.addDefaultValidationRules();
        GlobalContext.register(this, string);
    }

    private void addDefaultValidationRules() {
        if (this.required && !this.asContainment && this.kind != PropertyKind.BOOLEAN) {
            this.validationRules.add(new RequiredValidator());
        }
        if (EnumSet.of(PropertyKind.SET_OF_CI, PropertyKind.LIST_OF_CI).contains((Object)this.kind) && !this.asContainment) {
            this.validationRules.add(new ReferenceCollectionTypeValidator(this));
        }
    }

    private void initSyntheticValidationRules(Element element) {
        SyntheticHelper.forEach(SyntheticHelper.childByName(element, (Predicate<String>)Predicates.equalTo((Object)"rule")), new SyntheticHelper.Closure<Element>(){

            @Override
            public void call(Element element) {
                PropertyDescriptor.this.validationRules.add(ValidationRuleConverter.makeRule(element, PropertyDescriptor.this.getFqn()));
            }
        });
    }

    static PropertyDescriptor generateDeployableFrom(Descriptor descriptor, PropertyDescriptor propertyDescriptor) {
        PropertyDescriptor propertyDescriptor2 = new PropertyDescriptor(propertyDescriptor.getName());
        propertyDescriptor2.declaringDescriptor = descriptor;
        propertyDescriptor2.generateDeployable(propertyDescriptor);
        return propertyDescriptor2;
    }

    private void generateDeployable(PropertyDescriptor propertyDescriptor) {
        this.kind = propertyDescriptor.getKind().isSimple() ? PropertyKind.STRING : propertyDescriptor.getKind();
        this.category = propertyDescriptor.getCategory();
        this.label = propertyDescriptor.getLabel();
        this.description = String.format("%s (%s)", propertyDescriptor.getDescription(), propertyDescriptor.getKind().name().toLowerCase());
        this.required = false;
        this.password = propertyDescriptor.isPassword();
        this.size = propertyDescriptor.getSize();
        this.field = null;
    }

    public String getName() {
        return this.name;
    }

    public Field getField() {
        return this.field;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isAsContainment() {
        return this.asContainment;
    }

    public String getCategory() {
        return this.category;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isPassword() {
        return this.password;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Property.Size getSize() {
        return this.size;
    }

    public PropertyKind getKind() {
        return this.kind;
    }

    public List<String> getEnumValues() {
        return this.enumValues;
    }

    public Descriptor getDeclaringDescriptor() {
        return this.declaringDescriptor;
    }

    public Type getReferencedType() {
        return this.referencedType;
    }

    public Object getDefaultValue() {
        return this.convertValue(GlobalContext.lookup(this));
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public Object get(ConfigurationItem configurationItem) {
        if (this.field != null) {
            try {
                return this.field.get(configurationItem);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException("Cannot get field " + this.field, illegalAccessException);
            }
        }
        Map map = (Map)ReflectionUtils.getField(configurationItem, this.declaringDescriptor.getSyntheticPropertiesField());
        return map.get(this.name);
    }

    public void set(ConfigurationItem configurationItem, Object object) {
        if (this.kind.isSimple() && object instanceof String) {
            object = this.convertValue((String)object);
        } else if (object == null) {
            object = this.getDefaultValue();
        }
        try {
            if (this.field != null) {
                if (object == null) {
                    return;
                }
                this.field.set(configurationItem, object);
            } else {
                Map map = (Map)ReflectionUtils.getField(configurationItem, this.declaringDescriptor.getSyntheticPropertiesField());
                map.put(this.name, object);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Cannot set field " + this.field, illegalAccessException);
        }
    }

    public boolean areEqual(ConfigurationItem configurationItem, ConfigurationItem configurationItem2) {
        return this.areEqual(configurationItem, configurationItem2, new HashSet<String>());
    }

    boolean areEqual(ConfigurationItem configurationItem, ConfigurationItem configurationItem2, Set<String> set) {
        Object object = this.get(configurationItem);
        Object object2 = this.get(configurationItem2);
        return this.areValuesEqual(object, object2, set);
    }

    private boolean areValuesEqual(Object object, Object object2, Set<String> set) {
        if (object == null) {
            return object2 == null;
        }
        if (object2 == null) {
            return false;
        }
        switch (this.kind) {
            case SET_OF_STRING: {
                return Sets.symmetricDifference((Set)((Set)object), (Set)((Set)object2)).isEmpty();
            }
            case SET_OF_CI: {
                Function<ConfigurationItem, String> function = new Function<ConfigurationItem, String>(){

                    public String apply(ConfigurationItem configurationItem) {
                        return configurationItem.getName();
                    }
                };
                Iterable iterable = Iterables.concat((Iterable)((Set)object), (Iterable)((Set)object2));
                ImmutableListMultimap immutableListMultimap = Multimaps.index((Iterable)iterable, (Function)function);
                for (String string : immutableListMultimap.keySet()) {
                    Descriptor descriptor;
                    Collection collection = immutableListMultimap.get((Object)string);
                    if (collection.size() != 2) {
                        return false;
                    }
                    Iterator iterator = collection.iterator();
                    ConfigurationItem configurationItem = (ConfigurationItem)iterator.next();
                    ConfigurationItem configurationItem2 = (ConfigurationItem)iterator.next();
                    if (configurationItem.getType().equals(configurationItem2.getType()) && (descriptor = DescriptorRegistry.getDescriptor(configurationItem.getType())).areEqual(configurationItem, configurationItem2, set)) continue;
                    return false;
                }
                return true;
            }
            case CI: {
                ConfigurationItem configurationItem = (ConfigurationItem)object;
                ConfigurationItem configurationItem3 = (ConfigurationItem)object2;
                if (configurationItem.getName().equals(configurationItem3.getName())) {
                    Descriptor descriptor = DescriptorRegistry.getDescriptor(configurationItem.getType());
                    return descriptor.areEqual(configurationItem, configurationItem3, set);
                }
                return false;
            }
            case MAP_STRING_STRING: {
                Map map = (Map)object;
                Map map2 = (Map)object2;
                return Maps.difference((Map)map, (Map)map2).areEqual();
            }
            case LIST_OF_STRING: {
                List list = (List)object;
                List list2 = (List)object2;
                return ((Object)list).equals(list2);
            }
            case LIST_OF_CI: {
                List list = (List)object;
                List list3 = (List)object2;
                if (list.size() != list3.size()) {
                    return false;
                }
                Iterator iterator = list.iterator();
                Iterator iterator2 = list3.iterator();
                while (iterator.hasNext()) {
                    Descriptor descriptor;
                    ConfigurationItem configurationItem = (ConfigurationItem)iterator.next();
                    ConfigurationItem configurationItem4 = (ConfigurationItem)iterator2.next();
                    if (configurationItem.getName().equals(configurationItem4.getName()) && configurationItem.getType().equals(configurationItem4.getType()) && (descriptor = DescriptorRegistry.getDescriptor(configurationItem.getType())).areEqual(configurationItem, configurationItem4, set)) continue;
                    return false;
                }
                return true;
            }
        }
        return object.equals(object2);
    }

    private static String deCamelize(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (i == 0) {
                c = Character.toUpperCase(c);
            } else if (Character.isUpperCase(c)) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    void validate(final ConfigurationItem configurationItem, final List<ValidationMessage> list) {
        ValidationContext validationContext = new ValidationContext(){

            @Override
            public void error(String string, Object ... objectArray) {
                list.add(new ValidationMessage(configurationItem.getId(), PropertyDescriptor.this.name, String.format(string, objectArray)));
            }
        };
        for (Validator<?> validator : this.validationRules) {
            validator.validate(this.get(configurationItem), validationContext);
        }
    }

    public boolean isInspectionProperty() {
        return this.inspectionProperty;
    }

    public boolean isRequiredForInspection() {
        return this.requiredForInspection;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public String getFqn() {
        return this.declaringDescriptor.getType() + "." + this.name;
    }

    public String toString() {
        return this.getFqn();
    }

    public Object emptyValue() {
        switch (this.kind) {
            case BOOLEAN: {
                return false;
            }
            case SET_OF_STRING: 
            case SET_OF_CI: {
                return Sets.newHashSet();
            }
            case LIST_OF_STRING: 
            case LIST_OF_CI: {
                return Lists.newArrayList();
            }
            case MAP_STRING_STRING: {
                return Maps.newHashMap();
            }
        }
        return null;
    }
}

