/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.reflect;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.SyntheticHelper;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SyntheticInitializer {
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = SyntheticInitializer.createDocumentBuilderFactory();
    private static final Logger logger = LoggerFactory.getLogger(SyntheticInitializer.class);

    public static void init() {
        SyntheticInitializer.scanSynthetic();
    }

    static void scanSynthetic() {
        try {
            ArrayList arrayList = Lists.newArrayList();
            ArrayList arrayList2 = Lists.newArrayList();
            SyntheticInitializer.readSynthetics("synthetic.xml", arrayList, arrayList2);
            SyntheticInitializer.readSynthetics("synthetic-test.xml", arrayList, arrayList2);
            SyntheticInitializer.parseAllSyntheticTypeDefinitions(arrayList);
            SyntheticInitializer.parseAllSyntheticTypeModifications(arrayList2);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Cannot read synthetic configurations", iOException);
        }
    }

    private static void readSynthetics(String string, List<Element> list, List<Element> list2) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> enumeration = classLoader.getResources(string);
        while (enumeration.hasMoreElements()) {
            URL uRL = enumeration.nextElement();
            Element element = SyntheticInitializer.readSyntheticDocument(uRL).getDocumentElement();
            Iterators.addAll(list, SyntheticHelper.childByName(element, (Predicate<String>)Predicates.equalTo((Object)"type")));
            Iterators.addAll(list2, SyntheticHelper.childByName(element, (Predicate<String>)Predicates.equalTo((Object)"type-modification")));
        }
    }

    protected static void parseAllSyntheticTypeDefinitions(List<Element> list) {
        for (Element element : list) {
            DescriptorRegistry.registerSyntheticTypeDefinition(element);
        }
    }

    protected static void parseAllSyntheticTypeModifications(List<Element> list) {
        for (Element element : list) {
            DescriptorRegistry.registerSyntheticTypeModification(element);
        }
    }

    private static DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory documentBuilderFactory;
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(Thread.currentThread().getContextClassLoader().getResource("synthetic.xsd"));
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setSchema(schema);
        }
        catch (SAXException sAXException) {
            throw new RuntimeException("Cannot read schema synthetic.xsd", sAXException);
        }
        return documentBuilderFactory;
    }

    private static Document readSyntheticDocument(final URL uRL) throws IOException {
        InputStream inputStream = uRL.openStream();
        try {
            final boolean[] blArray = new boolean[1];
            DocumentBuilder documentBuilder = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
            documentBuilder.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException sAXParseException) throws SAXException {
                    logger.warn("Warning while parsing " + uRL, (Throwable)sAXParseException);
                }

                @Override
                public void error(SAXParseException sAXParseException) throws SAXException {
                    logger.error("Error while parsing " + uRL, (Throwable)sAXParseException);
                    blArray[0] = true;
                }

                @Override
                public void fatalError(SAXParseException sAXParseException) throws SAXException {
                    logger.error("Fatal error while parsing " + uRL, (Throwable)sAXParseException);
                    blArray[0] = true;
                }
            });
            Document document = documentBuilder.parse(inputStream);
            if (blArray[0]) {
                throw new RuntimeException("One or more errors were found while parsing " + uRL);
            }
            Document document2 = document;
            return document2;
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeException("Cannot read synthetic configuration " + uRL, runtimeException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException("Cannot read synthetic configuration " + uRL, parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new RuntimeException("Cannot read synthetic configuration " + uRL, sAXException);
        }
        finally {
            Closeables.closeQuietly((Closeable)inputStream);
        }
    }
}

