/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import java.io.OutputStream;
import java.io.PrintStream;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class DeployitOptions {
    @Option(name="-setup", usage="(Re-)run the setup for Deployit", required=false)
    private boolean doSetup = false;
    @Option(name="-reinitialize", usage="Reinitialize the repository, only useful with -setup", required=false)
    private boolean reinitialize = false;
    @Option(name="-force", required=false)
    private boolean force;
    @Option(name="-test-mode", required=false)
    private boolean isTestModeEnabled;
    @Option(name="-help", required=false, usage="Prints this usage message")
    private boolean printUsage = false;

    public boolean isDoSetup() {
        return this.doSetup;
    }

    public void setDoSetup(boolean bl) {
        this.doSetup = bl;
    }

    public boolean isReinitialize() {
        return this.reinitialize;
    }

    public void setReinitialize(boolean bl) {
        this.reinitialize = bl;
    }

    public boolean isTestModeEnabled() {
        return this.isTestModeEnabled;
    }

    public void setTestModeEnabled(boolean bl) {
        this.isTestModeEnabled = bl;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }

    public boolean isPrintUsage() {
        return this.printUsage;
    }

    public void setPrintUsage(boolean bl) {
        this.printUsage = bl;
    }

    static DeployitOptions parseCommandLine(String[] stringArray) {
        DeployitOptions deployitOptions = new DeployitOptions();
        CmdLineParser cmdLineParser = new CmdLineParser((Object)deployitOptions);
        try {
            cmdLineParser.parseArgument(stringArray);
            if (deployitOptions.isPrintUsage()) {
                DeployitOptions.printUsage(cmdLineParser, System.out);
                return null;
            }
        }
        catch (CmdLineException cmdLineException) {
            System.err.println(cmdLineException.getMessage());
            DeployitOptions.printUsage(cmdLineParser, System.err);
            return null;
        }
        return deployitOptions;
    }

    private static void printUsage(CmdLineParser cmdLineParser, PrintStream printStream) {
        printStream.println("java -cp deployit-server-<version>.jar [options...] com.xebialabs.deployit.Deployit arguments...");
        cmdLineParser.printUsage((OutputStream)printStream);
    }
}

