/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import java.io.InputStream;
import java.util.concurrent.atomic.AtomicReference;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sanitizer {
    private static final AtomicReference<Policy> policyReference = new AtomicReference();
    private static final Logger logger = LoggerFactory.getLogger(Sanitizer.class);

    public static String sanitize(String string) {
        if (policyReference.get() == null) {
            Sanitizer.init();
        }
        Policy policy = policyReference.get();
        AntiSamy antiSamy = new AntiSamy(policy);
        try {
            CleanResults cleanResults = antiSamy.scan(string);
            if (!cleanResults.getErrorMessages().isEmpty()) {
                logger.warn("Found errors during sanitation: {}", (Object)cleanResults.getErrorMessages());
            }
            return cleanResults.getCleanHTML();
        }
        catch (ScanException scanException) {
            throw new RuntimeException(scanException);
        }
        catch (PolicyException policyException) {
            throw new RuntimeException(policyException);
        }
    }

    private static void init() {
        InputStream inputStream = Sanitizer.class.getResourceAsStream("/antisamy-slashdot-1.4.4.xml");
        try {
            Policy policy = Policy.getInstance((InputStream)inputStream);
            policyReference.compareAndSet(null, policy);
        }
        catch (PolicyException policyException) {
            throw new RuntimeException(policyException);
        }
    }
}

