/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.python;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.inspection.InspectionPlanningContext;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployed;
import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;
import com.xebialabs.deployit.plugin.python.PythonInspectionStep;
import com.xebialabs.deployit.plugin.python.PythonManagedContainer;
import java.util.HashMap;
import java.util.Map;

public abstract class PythonManagedDeployed<D extends Deployable, C extends PythonManagedContainer>
extends BaseDeployed<D, C> {
    @Property(required=false, hidden=true, defaultValue="false", description="flag to indicate whether the deployed application CI is to be injected to the python script execution context.")
    private boolean exposeDeployedApplication;

    protected boolean addStep(DeploymentPlanningContext deploymentPlanningContext, int n, String string, String string2) {
        return this.addStep(deploymentPlanningContext, n, string, string2, true);
    }

    protected boolean addStep(DeploymentPlanningContext deploymentPlanningContext, int n, String string, String string2, boolean bl) {
        if (string != null) {
            PythonDeploymentStep pythonDeploymentStep = new PythonDeploymentStep(n, ((PythonManagedContainer)this.getContainer()).getManagingContainer(), string, this.getPythonVars(deploymentPlanningContext.getDeployedApplication()), this.getDescription(string2));
            pythonDeploymentStep.setUploadArtifactData(bl);
            deploymentPlanningContext.addStep((DeploymentStep)pythonDeploymentStep);
            return true;
        }
        return false;
    }

    protected boolean addStep(InspectionPlanningContext inspectionPlanningContext, String string, String string2) {
        if (string != null) {
            inspectionPlanningContext.addStep((Step)new PythonInspectionStep((ConfigurationItem)this, ((PythonManagedContainer)this.getContainer()).getManagingContainer(), string, this.getPythonVars(null), this.getDescription(string2)));
            return true;
        }
        return false;
    }

    protected Map<String, Object> getPythonVars() {
        return this.getPythonVars(null);
    }

    protected Map<String, Object> getPythonVars(DeployedApplication deployedApplication) {
        HashMap hashMap = Maps.newHashMap();
        hashMap.put("deployed", this);
        if (this.exposeDeployedApplication) {
            Preconditions.checkNotNull((Object)deployedApplication, (Object)"deployedApplication is null");
            hashMap.put("deployedApplication", deployedApplication);
        }
        return hashMap;
    }

    protected String getDescription(String string) {
        return String.format("%s %s on %s", string, this.getName(), ((PythonManagedContainer)this.getContainer()).getName());
    }

    public boolean getExposeDeployedApplication() {
        return this.exposeDeployedApplication;
    }

    public void setExposeDeployedApplication(boolean bl) {
        this.exposeDeployedApplication = bl;
    }
}

