/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.python;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.python.DerivedProperty;
import com.xebialabs.deployit.plugin.remoting.vars.VarsConverter;
import com.xebialabs.overthere.OverthereConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public class PythonVarsConverter
extends VarsConverter {
    public static String javaToPython(OverthereConnection overthereConnection, Map<String, Object> map) {
        return PythonVarsConverter.javaToPython(overthereConnection, map, true);
    }

    public static String javaToPython(OverthereConnection overthereConnection, Map<String, Object> map, boolean bl) {
        List<String> list = PythonVarsConverter.javaToPythonList(overthereConnection, map, bl);
        return Joiner.on((String)"\n").join(list) + "\n";
    }

    static List<String> javaToPythonList(OverthereConnection overthereConnection, Map<String, Object> map, boolean bl) {
        PythonVarsConverter pythonVarsConverter = new PythonVarsConverter(overthereConnection, map);
        pythonVarsConverter.setUploadArtifactData(bl);
        return pythonVarsConverter.convert();
    }

    private PythonVarsConverter(OverthereConnection overthereConnection, Map<String, Object> map) {
        super(overthereConnection, map, DerivedProperty.class);
    }

    protected void setNullVariable(String string) {
        this.add(string + " = None");
    }

    protected void setBooleanVariable(String string, boolean bl) {
        this.add(string + " = " + (bl ? "True" : "False"));
        this.add(string + "_as_string = " + (bl ? "'true'" : "'false'"));
    }

    protected void setIntegerVariable(String string, int n) {
        this.add(string + " = " + n);
    }

    protected void setLongVariable(String string, long l) {
        this.add(string + " = " + l + "L");
    }

    protected void setStringVariable(String string, String string2) {
        this.add(string + " = " + PythonVarsConverter.toPythonString(string2));
    }

    protected void setCiReferenceVariable(String string, ConfigurationItem configurationItem) {
        this.add(string + " = " + this.getConfigurationItemVariableName(configurationItem));
    }

    protected void setEmptyCollectionVariable(String string) {
        this.add(string + " = []");
    }

    protected void setCollectionOfStringsVariable(String string, Collection<?> collection) {
        if (collection.isEmpty()) {
            this.setEmptyCollectionVariable(string);
        } else {
            Collection collection2 = Collections2.transform(collection, (Function)new Function<Object, String>(){

                public String apply(Object object) {
                    return PythonVarsConverter.toPythonString(object.toString());
                }
            });
            this.add(string + " = [" + Joiner.on((String)", ").join((Iterable)collection2) + "]");
        }
    }

    protected void createObject(String string) {
        this.add(string + " = DictionaryObject()");
    }

    protected void setNullProperty(String string, String string2) {
        this.setNullVariable(string + "." + string2);
    }

    protected void setEmptyCollectionProperty(String string, String string2) {
        this.setEmptyCollectionVariable(string + "." + string2);
    }

    protected void setEmptyMapProperty(String string, String string2) {
        this.add(string + "." + string2 + " = {}");
    }

    protected void setBooleanProperty(String string, String string2, boolean bl) {
        this.setBooleanVariable(string + "." + string2, bl);
    }

    protected void setIntegerProperty(String string, String string2, int n) {
        this.setIntegerVariable(string + "." + string2, n);
    }

    protected void setStringProperty(String string, String string2, String string3) {
        this.setStringVariable(string + "." + string2, string3);
    }

    protected void setPasswordProperty(String string, String string2, String string3) {
        this.add(string + "." + string2 + " = base64.decodestring(" + PythonVarsConverter.toPythonString(Base64.encodeBase64String((byte[])string3.getBytes())) + ")");
    }

    protected void setCollectionOfStringsProperty(String string, String string2, Collection<?> collection) {
        this.setCollectionOfStringsVariable(string + "." + string2, collection);
    }

    protected void setCiReferenceProperty(String string, String string2, ConfigurationItem configurationItem) {
        this.add(string + "." + string2 + " = " + this.getConfigurationItemVariableName(configurationItem));
    }

    protected void setCollectionOfCiReferencesProperty(String string, String string2, Collection<ConfigurationItem> collection) {
        if (collection.isEmpty()) {
            this.setEmptyCollectionVariable(string + "." + string2);
        } else {
            ArrayList arrayList = Lists.newArrayList();
            for (ConfigurationItem configurationItem : collection) {
                arrayList.add(this.getConfigurationItemVariableName(configurationItem));
            }
            this.add(string + "." + string2 + " = [" + Joiner.on((String)", ").join((Iterable)arrayList) + "]");
        }
    }

    protected void setMapOfStringToStringReferencesProperty(String string, String string2, Map<String, String> map) {
        if (map.isEmpty()) {
            this.setEmptyMapProperty(string, string2);
        } else {
            ArrayList arrayList = Lists.newArrayList();
            for (String string3 : map.keySet()) {
                String string4 = map.get(string3);
                if (string4 == null) {
                    arrayList.add(PythonVarsConverter.toPythonString(string3) + ": None");
                    continue;
                }
                arrayList.add(PythonVarsConverter.toPythonString(string3) + ": " + PythonVarsConverter.toPythonString(string4));
            }
            this.add(string + "." + string2 + " = {" + Joiner.on((String)", ").join((Iterable)arrayList) + "}");
        }
    }

    protected void createObjectAndSetObjectProperty(String string, String string2) {
        this.createObject(string + "." + string2);
    }

    public static String toPythonString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\"");
        block5: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block5;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block5;
                }
                case '\"': 
                case '\'': 
                case '\\': {
                    stringBuilder.append('\\');
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        stringBuilder.append("\"");
        return stringBuilder.toString();
    }
}

