/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.overthere.step;

import com.google.common.base.Throwables;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.overthere.AutoFlushingExecutionContextOverthereProcessOutputHandler;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcessOutputHandler;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.Closeable;

public class CheckConnectionStep
implements Step<DeploymentExecutionContext> {
    private Host host;

    public CheckConnectionStep(Host host) {
        this.host = host;
    }

    public String getDescription() {
        return "Check connection to " + this.host.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Step.Result execute(DeploymentExecutionContext deploymentExecutionContext) throws Exception {
        AutoFlushingExecutionContextOverthereProcessOutputHandler autoFlushingExecutionContextOverthereProcessOutputHandler = new AutoFlushingExecutionContextOverthereProcessOutputHandler((ExecutionContext)deploymentExecutionContext);
        try {
            OverthereConnection overthereConnection;
            String string = this.host.getName();
            if (this.host.hasProperty("address")) {
                string = (String)this.host.getProperty("address");
            }
            try {
                overthereConnection = this.host.getConnection();
                try {
                    deploymentExecutionContext.logOutput("Attempting to list the contents of the temporary directory");
                    deploymentExecutionContext.logOutput("----------------------------------------------------------");
                    this.echoTmpDirContents(overthereConnection, autoFlushingExecutionContextOverthereProcessOutputHandler);
                    deploymentExecutionContext.logOutput("----------------------------------------------------------");
                    deploymentExecutionContext.logOutput("Uploading file to the temporary directory");
                    deploymentExecutionContext.logOutput("----------------------------------------------------------");
                    OverthereFile overthereFile = this.uploadFile(overthereConnection);
                    deploymentExecutionContext.logOutput("-----------------------------------------");
                    deploymentExecutionContext.logOutput("Checking read permission of uploaded file");
                    deploymentExecutionContext.logOutput("-----------------------------------------");
                    this.tryCanGetFilePermissions(overthereConnection, overthereFile);
                    deploymentExecutionContext.logOutput("-----------------------------------------");
                }
                finally {
                    Closeables.closeQuietly((Closeable)overthereConnection);
                }
            }
            catch (Exception exception) {
                autoFlushingExecutionContextOverthereProcessOutputHandler.handleErrorLine(String.format("Connection test to host " + string + " failed. Please check address, username and password. Exception message is: %s%n%s", exception, Throwables.getStackTraceAsString((Throwable)exception)));
                Step.Result result = Step.Result.Fail;
                autoFlushingExecutionContextOverthereProcessOutputHandler.close();
                return result;
            }
            autoFlushingExecutionContextOverthereProcessOutputHandler.handleOutputLine("Connection test to host " + string + " succeeded");
            overthereConnection = Step.Result.Success;
            return overthereConnection;
        }
        finally {
            autoFlushingExecutionContextOverthereProcessOutputHandler.close();
        }
    }

    private void echoTmpDirContents(OverthereConnection overthereConnection, OverthereProcessOutputHandler overthereProcessOutputHandler) {
        String string = overthereConnection.getHostOperatingSystem() == OperatingSystemFamily.UNIX ? "ls" : "dir";
        CmdLine cmdLine = new CmdLine();
        cmdLine.addArgument(string);
        String string2 = this.host.getTemporaryDirectoryPath();
        if (string2 == null) {
            string2 = overthereConnection.getHostOperatingSystem().getDefaultTemporaryDirectoryPath();
        }
        cmdLine.addArgument(string2);
        overthereConnection.execute(overthereProcessOutputHandler, cmdLine);
    }

    private OverthereFile uploadFile(OverthereConnection overthereConnection) {
        OverthereFile overthereFile = overthereConnection.getTempFile("hostconnection-remote", ".txt");
        OverthereUtils.write((String)"Contents of host connection test file", (String)"UTF-8", (OverthereFile)overthereFile);
        return overthereFile;
    }

    private void tryCanGetFilePermissions(OverthereConnection overthereConnection, OverthereFile overthereFile) {
        OverthereFile overthereFile2 = overthereConnection.getFile(overthereFile.getPath());
        if (!overthereFile2.canRead()) {
            throw new RuntimeException("Cannot check read permission for file just uploaded");
        }
    }
}

