/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

class PackageScanner {
    private static final Logger logger = LoggerFactory.getLogger(PackageScanner.class);

    PackageScanner() {
    }

    static Set<String> scan(File file) {
        if (!file.exists() || !file.isDirectory()) {
            throw new IllegalArgumentException("Directory " + file.getAbsolutePath() + " does not exist or is not a directory");
        }
        HashSet hashSet = Sets.newHashSet();
        logger.debug("Listing importable packages in {}", (Object)file.getAbsolutePath());
        PackageScanner.scanDirectory(file, hashSet, "");
        logger.debug("Returning the following packages: {}", (Object)hashSet);
        return hashSet;
    }

    private static void scanDirectory(File file, Set<String> set, String string) {
        File[] fileArray = file.listFiles();
        logger.debug("Found {} possible packages.", (Object)fileArray.length);
        for (File file2 : fileArray) {
            if (PackageScanner.isExplodedPackage(file2)) {
                set.add(string + file2.getName());
                continue;
            }
            if (PackageScanner.isDarPackage(file2)) {
                set.add(string + file2.getName());
                continue;
            }
            if (!file2.isDirectory()) continue;
            PackageScanner.scanDirectory(file2, set, string + file2.getName() + "/");
        }
    }

    static boolean isDarPackage(File file) {
        return file.isFile() && StringUtils.endsWithIgnoreCase((String)file.getName(), (String)".dar");
    }

    static boolean isExplodedPackage(File file) {
        if (file.isDirectory()) {
            File file2 = PackageScanner.getManifestFileForUnpackedPackage(file);
            return file2.exists();
        }
        return false;
    }

    static File getManifestFileForUnpackedPackage(File file) {
        File file2 = new File(new File(file, "META-INF"), "MANIFEST.MF");
        return file2;
    }

    public static TFile getManifestFileFromImportSource(ImportSource importSource) {
        File file = importSource.getFile();
        return new TFile((File)new TFile(file, "META-INF"), "MANIFEST.MF");
    }
}

