/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task;

import com.xebialabs.deployit.checks.Checks;
import java.util.Calendar;

public class ArchivedTaskSearchParameters {
    protected Calendar startDate;
    protected Calendar endDate;
    protected String executedBy;
    protected String application;
    protected String version;
    protected String environment;
    protected String taskUuid;
    protected DateRange dateRangeSearch = DateRange.NONE;
    protected Status status = Status.ANY;

    public ArchivedTaskSearchParameters() {
    }

    protected ArchivedTaskSearchParameters(ArchivedTaskSearchParameters archivedTaskSearchParameters) {
        this.startDate = archivedTaskSearchParameters.startDate;
        this.endDate = archivedTaskSearchParameters.endDate;
        this.executedBy = archivedTaskSearchParameters.executedBy;
        this.application = archivedTaskSearchParameters.application;
        this.version = archivedTaskSearchParameters.version;
        this.environment = archivedTaskSearchParameters.environment;
        this.dateRangeSearch = archivedTaskSearchParameters.dateRangeSearch;
        this.status = archivedTaskSearchParameters.status;
        this.taskUuid = archivedTaskSearchParameters.taskUuid;
    }

    public ArchivedTaskSearchParameters executedByUser(String string) {
        this.executedBy = string;
        return this;
    }

    public ArchivedTaskSearchParameters createdBetween(Calendar calendar, Calendar calendar2) {
        Checks.checkNotNull(calendar, "Start date cannot be null");
        Checks.checkNotNull(calendar2, "End date cannot be null");
        this.dateRangeSearch = DateRange.BETWEEN;
        if (calendar.after(calendar2)) {
            this.startDate = calendar2;
            this.endDate = calendar;
        } else {
            this.startDate = calendar;
            this.endDate = calendar2;
        }
        return this;
    }

    public ArchivedTaskSearchParameters createdOnOrBefore(Calendar calendar) {
        Checks.checkNotNull(calendar, "End date cannot be null");
        this.dateRangeSearch = DateRange.BEFORE;
        this.endDate = calendar;
        return this;
    }

    public ArchivedTaskSearchParameters createdOnOrAfter(Calendar calendar) {
        Checks.checkNotNull(calendar, "Start date cannot be null");
        this.dateRangeSearch = DateRange.AFTER;
        this.startDate = calendar;
        return this;
    }

    public ArchivedTaskSearchParameters forApplicationAndVersion(String string, String string2) {
        this.application = string;
        this.version = string2;
        return this;
    }

    public ArchivedTaskSearchParameters forApplication(String string) {
        return this.forApplicationAndVersion(string, null);
    }

    public ArchivedTaskSearchParameters toEnvironment(String string) {
        this.environment = string;
        return this;
    }

    public ArchivedTaskSearchParameters thatWasCancelled() {
        this.status = Status.CANCELLED;
        return this;
    }

    public ArchivedTaskSearchParameters thatCompleted() {
        this.status = Status.COMPLETED;
        return this;
    }

    public ArchivedTaskSearchParameters thatCompletedAfterRetry() {
        this.status = Status.COMPLETED_AFTER_RETRY;
        return this;
    }

    public ArchivedTaskSearchParameters withUniqueId(String string) {
        this.taskUuid = string;
        return this;
    }

    public static enum Status {
        COMPLETED,
        CANCELLED,
        COMPLETED_AFTER_RETRY,
        ANY;

    }

    public static enum DateRange {
        AFTER,
        BEFORE,
        BETWEEN,
        NONE;

    }
}

