/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task.deployment;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.security.SecurityCallback;
import com.xebialabs.deployit.security.SecurityTemplate;
import com.xebialabs.deployit.task.DeploymentTask;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;

public class UpgradeDeploymentTask
extends DeploymentTask {
    private DeltaSpecification specification;
    private DeployedApplication oldApp;
    private static final Logger logger = LoggerFactory.getLogger(UpgradeDeploymentTask.class);

    public UpgradeDeploymentTask(DeltaSpecification deltaSpecification, DeployedApplication deployedApplication, List<? extends DeploymentStep> list, RepositoryService repositoryService, WorkDir workDir, WorkDir workDir2) {
        super(list, repositoryService, workDir, workDir2);
        this.specification = deltaSpecification;
        this.oldApp = deployedApplication;
        this.initFromDeployment(deltaSpecification.getDeployedApplication());
    }

    @Override
    public void performPreFlightChecks() {
        Authentication authentication = this.getOwnerCredentials();
        SecurityTemplate.executeAs(authentication, new SecurityCallback<Object>(){

            @Override
            public Object doAs() {
                UpgradeDeploymentTask.this.repositoryService.checkReferentialIntegrity(UpgradeDeploymentTask.this.determineRepositoryChanges());
                return null;
            }
        });
    }

    private ChangeSet determineRepositoryChanges() {
        DeployedApplication deployedApplication = this.specification.getDeployedApplication();
        ArrayList arrayList = Lists.newArrayList();
        ArrayList arrayList2 = Lists.newArrayList();
        ArrayList arrayList3 = Lists.newArrayList();
        for (Delta delta : this.specification.getDeltas()) {
            switch (delta.getOperation()) {
                case CREATE: {
                    arrayList.add(delta.getDeployed());
                    deployedApplication.addDeployed(delta.getDeployed());
                    logger.info("The CI {} was {} in the repository", (Object)delta.getDeployed().getId(), (Object)delta.getOperation());
                    break;
                }
                case DESTROY: {
                    this.oldApp.getDeployeds().remove(delta.getPrevious());
                    arrayList2.add(this.oldApp);
                    arrayList3.add(delta.getPrevious().getId());
                    logger.info("The CI {} was {} in the repository", (Object)delta.getPrevious().getId(), (Object)delta.getOperation());
                    break;
                }
                case MODIFY: 
                case NOOP: {
                    arrayList2.add(delta.getDeployed());
                    deployedApplication.addDeployed(delta.getDeployed());
                    logger.info("The CI {} was {} in the repository", (Object)delta.getDeployed().getId(), (Object)delta.getOperation());
                }
            }
        }
        arrayList2.add(deployedApplication);
        ChangeSet changeSet = new ChangeSet();
        changeSet.setDeleteCiIds(arrayList3);
        changeSet.setCreateCis(arrayList);
        changeSet.setUpdateCis(arrayList2);
        return changeSet;
    }

    @Override
    public void doAfterTaskStateChangedToDone() {
        Authentication authentication = this.getOwnerCredentials();
        SecurityTemplate.executeAs(authentication, new SecurityCallback<Object>(){

            @Override
            public Object doAs() {
                UpgradeDeploymentTask.this.repositoryService.execute(UpgradeDeploymentTask.this.determineRepositoryChanges());
                return null;
            }
        });
    }

    @Override
    public DeploymentTask.DeploymentType getDeploymentType() {
        return DeploymentTask.DeploymentType.UPGRADE;
    }
}

